/*
 * Decompiled with CFR 0.152.
 */
package dev.ninjdai.letsdocompat.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.ninjdai.letsdocompat.Compat;
import dev.ninjdai.letsdocompat.DoAddonExpectPlatform;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RecipeManager.class})
public abstract class RecipeManagerMixin {
    @Inject(method={"apply*"}, at={@At(value="HEAD")})
    public void interceptApply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller, CallbackInfo info) {
        HashMap<ResourceLocation, JsonObject> tMap = new HashMap<ResourceLocation, JsonObject>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation id;
            ResourceLocation resourceLocation = entry.getKey();
            JsonObject jsonRecipe = entry.getValue().getAsJsonObject();
            if (!jsonRecipe.has("type")) continue;
            String recipeType = jsonRecipe.get("type").getAsString();
            if (recipeType.equals("farm_and_charm:pot_cooking")) {
                if (!DoAddonExpectPlatform.isModLoaded("farmersdelight")) continue;
                JsonObject FDCookingPotRecipe = new JsonObject();
                FDCookingPotRecipe.add("type", (JsonElement)new JsonPrimitive("farmersdelight:cooking"));
                FDCookingPotRecipe.add("recipe_book_tab", (JsonElement)new JsonPrimitive("meals"));
                FDCookingPotRecipe.add("ingredients", (JsonElement)jsonRecipe.getAsJsonArray("ingredients"));
                try {
                    JsonObject ldContainer = jsonRecipe.getAsJsonObject("container");
                    if (!ldContainer.get("required").getAsBoolean()) {
                        FDCookingPotRecipe.add("container", ldContainer.get("item"));
                    }
                }
                catch (Exception e) {
                    Compat.LOGGER.error("Error while reading recipe container");
                }
                FDCookingPotRecipe.add("result", jsonRecipe.get("result"));
                id = new ResourceLocation("letsdocompat", "farm_and_charm/" + resourceLocation.m_135815_());
                tMap.put(id, FDCookingPotRecipe);
                continue;
            }
            if (!recipeType.equals("farmersdelight:cooking") || !DoAddonExpectPlatform.isModLoaded("farm_and_charm")) continue;
            JsonObject letsDoCookingPotRecipe = new JsonObject();
            letsDoCookingPotRecipe.add("type", (JsonElement)new JsonPrimitive("farm_and_charm:pot_cooking"));
            letsDoCookingPotRecipe.add("ingredients", (JsonElement)jsonRecipe.getAsJsonArray("ingredients"));
            if (jsonRecipe.has("container")) {
                JsonObject containerObject = new JsonObject();
                containerObject.add("required", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
                containerObject.add("item", jsonRecipe.get("container"));
                letsDoCookingPotRecipe.add("container", (JsonElement)containerObject);
            } else {
                try {
                    Item i = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(jsonRecipe.get("result").getAsJsonObject().get("item").getAsString()));
                    if (!i.m_41470_()) continue;
                    JsonObject container = new JsonObject();
                    container.add("required", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
                    JsonObject itemObject = new JsonObject();
                    itemObject.add("item", (JsonElement)new JsonPrimitive(i.m_41469_().arch$registryName().toString()));
                    container.add("item", (JsonElement)itemObject);
                    letsDoCookingPotRecipe.add("container", (JsonElement)container);
                }
                catch (Exception e) {
                    Compat.LOGGER.error("Error getting item from Item Registry: {}", (Object)e.getMessage());
                    continue;
                }
            }
            letsDoCookingPotRecipe.add("result", jsonRecipe.get("result"));
            letsDoCookingPotRecipe.add("requiresLearning", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
            id = new ResourceLocation("letsdocompat", "farmersdelight/" + resourceLocation.m_135815_());
            tMap.put(id, letsDoCookingPotRecipe);
        }
        map.putAll(tMap);
        Compat.LOGGER.info("Added {} compatibility recipes !", (Object)tMap.size());
    }
}

