/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.barbequesdelight;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.wallev.maidsoulkitchen.init.MkEntities;
import com.github.wallev.maidsoulkitchen.task.cook.barbequesdelight.TaskBdBasin;
import com.github.wallev.maidsoulkitchen.task.cook.common.inventory.MaidRecipesManager;
import com.github.wallev.verhelper.server.ai.VBehaviorControl;
import com.google.common.collect.ImmutableMap;
import com.mao.barbequesdelight.content.block.BasinBlockEntity;
import com.mao.barbequesdelight.content.recipe.SkeweringRecipe;
import com.mao.barbequesdelight.init.registrate.BBQDRecipes;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class MaidBasinMakeTask
extends Behavior<EntityMaid>
implements VBehaviorControl {
    private final TaskBdBasin task;
    private final MaidRecipesManager<SkeweringRecipe<?>> maidRecipesManager;
    private int tick;
    private int time;
    private ItemStack container = ItemStack.f_41583_;
    private ItemStack tool = ItemStack.f_41583_;
    private ItemStack side = ItemStack.f_41583_;

    public MaidBasinMakeTask(TaskBdBasin task, MaidRecipesManager<SkeweringRecipe<?>> maidRecipesManager) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)InitEntities.TARGET_POS.get()), (Object)MemoryStatus.VALUE_PRESENT), 1200);
        this.task = task;
        this.maidRecipesManager = maidRecipesManager;
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid maid) {
        Brain brain = maid.m_6274_();
        return brain.m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).map(targetPos -> {
            Vec3 targetV3d = targetPos.m_7024_();
            return !(maid.m_20238_(targetV3d) > Math.pow(this.task.getCloseEnoughDist(), 2.0));
        }).orElse(false);
    }

    protected boolean canStillUse(ServerLevel worldIn, EntityMaid maid, long pGameTime) {
        return maid.m_6274_().m_21874_((MemoryModuleType)InitEntities.TARGET_POS.get());
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long pGameTime) {
        super.m_6735_(worldIn, (LivingEntity)maid, pGameTime);
        maid.m_6274_().m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).ifPresent(posWrapper -> {
            BlockEntity blockEntity = worldIn.m_7702_(posWrapper.m_6675_());
            if (blockEntity instanceof BasinBlockEntity) {
                BasinBlockEntity basinBlockEntity = (BasinBlockEntity)blockEntity;
                IItemHandlerModifiable inputInv = this.maidRecipesManager.getInputInv();
                if (!basinBlockEntity.items.m_7983_()) {
                    for (ItemStack itemStack : basinBlockEntity.items.getAsList()) {
                        ItemStack leftStack = ItemHandlerHelper.insertItemStacked((IItemHandler)inputInv, (ItemStack)itemStack.m_41777_(), (boolean)false);
                        itemStack.m_41774_(itemStack.m_41613_() - leftStack.m_41613_());
                    }
                }
                if (!basinBlockEntity.items.m_7983_()) {
                    return;
                }
                if (!this.maidRecipesManager.getRecipesIngredients().isEmpty()) {
                    Pair<List<Integer>, List<List<ItemStack>>> recipeIngredient = this.maidRecipesManager.getRecipeIngredient();
                    this.time = (Integer)((List)recipeIngredient.getFirst()).get(0);
                    List second = (List)recipeIngredient.getSecond();
                    ItemStack containerStack = (ItemStack)((List)second.get(0)).get(0);
                    basinBlockEntity.items.m_19173_(containerStack);
                    containerStack.m_41764_(0);
                    this.container = basinBlockEntity.items.m_8020_(0);
                    this.tool = (ItemStack)((List)second.get(1)).get(0);
                    if (second.size() > 2) {
                        this.side = (ItemStack)((List)second.get(2)).get(0);
                    }
                }
                this.maidRecipesManager.getCookInv().syncInv();
            }
        });
    }

    protected void tick(ServerLevel worldIn, EntityMaid maid, long pGameTime) {
        if (this.tick++ % 5 != 0) {
            return;
        }
        maid.m_6274_().m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).ifPresent(posWrapper -> {
            BlockEntity blockEntity = worldIn.m_7702_(posWrapper.m_6675_());
            if (blockEntity instanceof BasinBlockEntity) {
                BasinBlockEntity basinBlockEntity = (BasinBlockEntity)blockEntity;
                IItemHandlerModifiable outputInv = this.maidRecipesManager.getOutputInv();
                SimpleContainer cont = new SimpleContainer(new ItemStack[]{this.tool, this.container, this.side});
                Optional optional = worldIn.m_7465_().m_44015_((RecipeType)BBQDRecipes.RT_SKR.get(), (Container)cont, (Level)worldIn);
                if (optional.isEmpty()) {
                    this.stop(worldIn, maid, pGameTime);
                    basinBlockEntity.notifyTile();
                    this.time = 0;
                    this.tool = ItemStack.f_41583_;
                    this.container = ItemStack.f_41583_;
                    this.side = ItemStack.f_41583_;
                    return;
                }
                SkeweringRecipe recipe = (SkeweringRecipe)optional.get();
                ItemStack ret = recipe.m_5874_((Container)cont, worldIn.m_9598_());
                ItemHandlerHelper.insertItemStacked((IItemHandler)outputInv, (ItemStack)ret, (boolean)false);
                maid.m_6674_(InteractionHand.MAIN_HAND);
                basinBlockEntity.notifyTile();
            }
        });
    }

    protected void stop(ServerLevel worldIn, EntityMaid maid, long pGameTime) {
        super.m_6732_(worldIn, (LivingEntity)maid, pGameTime);
        maid.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        maid.m_6274_().m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
        maid.m_6274_().m_21936_((MemoryModuleType)MkEntities.WORK_POS.get());
    }
}

