/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.farmersrespite;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.task.cook.common.inventory.MaidRecipesManager;
import com.github.wallev.maidsoulkitchen.task.cook.farmersrespite.TaskFrKettle;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import umpaz.farmersrespite.common.crafting.KettleRecipe;

public class KettleRecipesManager
extends MaidRecipesManager<KettleRecipe> {
    public KettleRecipesManager(EntityMaid maid, TaskFrKettle task) {
        super(maid, task, false);
    }

    @Override
    protected Pair<List<Integer>, List<Item>> getAmountIngredient(KettleRecipe recipe, Map<Item, Integer> available) {
        boolean hasIngredient;
        TaskFrKettle.MaidKettleRecipe maidKettleRecipe = TaskFrKettle.KEY_RECIPE_INGREDIENTS.get(recipe);
        ArrayList<Item> invIngredient = new ArrayList<Item>();
        HashMap<Item, Integer> itemTimes = new HashMap<Item, Integer>();
        boolean[] single = new boolean[]{false};
        boolean hasFluidItem = false;
        int fluidItemAmount = 0;
        Item fluidItem = ItemStack.f_41583_.m_41720_();
        for (ItemStack itemStack : maidKettleRecipe.inFluids()) {
            hasIngredient = false;
            for (Item item : available.keySet()) {
                if (!itemStack.m_150930_(item) || available.get(item) < itemStack.m_41613_()) continue;
                invIngredient.add(item);
                hasIngredient = true;
                if (item.m_41459_() == 1) {
                    single[0] = true;
                    itemTimes.put(item, 1);
                } else {
                    itemTimes.merge(item, 1, Integer::sum);
                }
                fluidItemAmount = itemStack.m_41613_();
                fluidItem = item;
                single[0] = true;
                break;
            }
            if (!hasIngredient) continue;
            hasFluidItem = true;
            break;
        }
        if (!maidKettleRecipe.inFluids().isEmpty() && !hasFluidItem) {
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        for (Ingredient ingredient : maidKettleRecipe.inItems()) {
            hasIngredient = false;
            for (Item item : available.keySet()) {
                ItemStack stack = item.m_7968_();
                if (!ingredient.test(stack)) continue;
                invIngredient.add(item);
                hasIngredient = true;
                if (stack.m_41741_() == 1) {
                    single[0] = true;
                    itemTimes.put(item, 1);
                    break;
                }
                itemTimes.merge(item, 1, Integer::sum);
                break;
            }
            if (hasIngredient) continue;
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        if (itemTimes.entrySet().stream().anyMatch(entry -> (Integer)available.get(entry.getKey()) < (Integer)entry.getValue())) {
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        int maxCount = 64;
        if (single[0]) {
            maxCount = 1;
        } else {
            for (Item item : itemTimes.keySet()) {
                maxCount = Math.min(maxCount, item.m_7968_().m_41741_());
                maxCount = Math.min(maxCount, available.get(item) / (Integer)itemTimes.get(item));
            }
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (!maidKettleRecipe.inFluids().isEmpty()) {
            arrayList.add(0, fluidItemAmount);
            available.put(fluidItem, available.get(fluidItem) - fluidItemAmount);
        } else {
            arrayList.add(0, 0);
            invIngredient.add(0, ItemStack.f_41583_.m_41720_());
        }
        for (Item item : invIngredient.stream().skip(1L).toList()) {
            arrayList.add(maxCount);
            available.put(item, available.get(item) - maxCount);
        }
        return Pair.of(arrayList, invIngredient);
    }
}

