/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.minersdelight;

import com.sammy.minersdelight.data.MDBlockTags;
import com.sammy.minersdelight.data.MDItemTags;
import com.sammy.minersdelight.data.MDLangMerger;
import com.sammy.minersdelight.data.MDRecipeProvider;
import com.sammy.minersdelight.repack.registrate.Registrate;
import com.sammy.minersdelight.repack.registrate.util.nullness.NonNullSupplier;
import com.sammy.minersdelight.setup.MDBlockEntities;
import com.sammy.minersdelight.setup.MDBlocks;
import com.sammy.minersdelight.setup.MDCauldronInteractions;
import com.sammy.minersdelight.setup.MDComposting;
import com.sammy.minersdelight.setup.MDCreativeTabs;
import com.sammy.minersdelight.setup.MDItems;
import com.sammy.minersdelight.setup.MDLootConditions;
import com.sammy.minersdelight.setup.MDLootFunctions;
import com.sammy.minersdelight.setup.MDLootModifiers;
import com.sammy.minersdelight.setup.MDMenuTypes;
import com.sammy.minersdelight.setup.MDPotions;
import com.sammy.minersdelight.setup.MDWorldgen;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="miners_delight")
public class MinersDelightMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "miners_delight";
    public static final Random RANDOM = new Random();
    public static final NonNullSupplier<Registrate> REGISTRATE = NonNullSupplier.lazy(() -> Registrate.create(MODID));

    public static Registrate registrate() {
        return REGISTRATE.get();
    }

    public MinersDelightMod() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        MDLootModifiers.LOOT_MODIFIERS.register(modBus);
        MDLootConditions.LOOT_CONDITIONS.register(modBus);
        MDLootFunctions.LOOT_FUNCTIONS.register(modBus);
        MDMenuTypes.MENU_TYPES.register(modBus);
        MDCreativeTabs.CREATIVE_TABS.register(modBus);
        MDPotions.POTIONS.register(modBus);
        MDBlocks.register();
        MDItems.register();
        MDBlockEntities.register();
        MDWorldgen.register();
        modBus.addListener(MDCauldronInteractions::addCauldronInteractions);
        modBus.addListener(MDPotions::addPotionMixing);
        modBus.addListener(MDComposting::addCompostValues);
        modBus.addListener(DataOnly::gatherData);
    }

    public static ResourceLocation path(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static class DataOnly {
        public static void gatherData(GatherDataEvent event) {
            DataGenerator generator = event.getGenerator();
            PackOutput packOutput = generator.getPackOutput();
            CompletableFuture provider = event.getLookupProvider();
            ExistingFileHelper helper = event.getExistingFileHelper();
            MDBlockTags blockTagsProvider = new MDBlockTags(packOutput, provider, helper);
            generator.addProvider(true, (DataProvider)new MDLangMerger(packOutput));
            generator.addProvider(true, (DataProvider)new MDRecipeProvider(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
            generator.addProvider(event.includeServer(), (DataProvider)new MDItemTags(packOutput, provider, blockTagsProvider.m_274426_(), helper));
        }
    }
}

