/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.markers.SimpleMapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.misc.StrOpt;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import org.jetbrains.annotations.Nullable;

public final class JsonDecorationType
implements MapDecorationType<CustomMapDecoration, SimpleMapBlockMarker> {
    public static final Codec<JsonDecorationType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(RuleTest.f_74307_, "target_block").forGetter(JsonDecorationType::getTarget), (App)StrOpt.of(Codec.STRING, "name").forGetter(JsonDecorationType::getName), (App)StrOpt.of(Codec.INT, "rotation", 0).forGetter(JsonDecorationType::getRotation), (App)StrOpt.of(ColorUtils.CODEC, "map_color", 0).forGetter(JsonDecorationType::getDefaultMapColor), (App)StrOpt.of(RegistryCodecs.m_206277_((ResourceKey)Registries.f_256944_), "target_structures").forGetter(JsonDecorationType::getAssociatedStructure), (App)Codec.STRING.xmap(PlatHelper::isModLoaded, b -> "minecraft").optionalFieldOf("from_mod", (Object)true).forGetter(t -> t.enabled)).apply((Applicative)instance, JsonDecorationType::new));
    public static final Codec<JsonDecorationType> NETWORK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(RuleTest.f_74307_, "target_block").forGetter(JsonDecorationType::getTarget), (App)StrOpt.of(Codec.STRING, "name").forGetter(JsonDecorationType::getName), (App)StrOpt.of(Codec.INT, "rotation", 0).forGetter(JsonDecorationType::getRotation), (App)StrOpt.of(ColorUtils.CODEC, "map_color", 0).forGetter(JsonDecorationType::getDefaultMapColor), (App)Codec.BOOL.fieldOf("enabled").forGetter(t -> t.enabled)).apply((Applicative)instance, JsonDecorationType::new));
    @Nullable
    private final RuleTest target;
    @Nullable
    private final String name;
    @Nullable
    private final HolderSet<Structure> structures;
    private final int mapColor;
    private final int rotation;
    private final boolean enabled;

    public JsonDecorationType(Optional<RuleTest> target) {
        this(target, Optional.empty(), 0, 0, true);
    }

    public JsonDecorationType(Optional<RuleTest> target, Optional<String> name, int rotation, int mapColor, boolean enabled) {
        this(target, name, rotation, mapColor, Optional.empty(), enabled);
    }

    public JsonDecorationType(Optional<RuleTest> target, Optional<String> name, int rotation, int mapColor, Optional<HolderSet<Structure>> structure, Boolean enabled) {
        this.target = target.orElse(null);
        this.name = name.orElse(null);
        this.rotation = rotation;
        this.structures = structure.orElse(null);
        this.mapColor = mapColor;
        this.enabled = enabled;
    }

    public Optional<RuleTest> getTarget() {
        return Optional.ofNullable(this.target);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public int getRotation() {
        return this.rotation;
    }

    @Override
    public Optional<HolderSet<Structure>> getAssociatedStructure() {
        return Optional.ofNullable(this.structures);
    }

    @Override
    public int getDefaultMapColor() {
        return this.mapColor;
    }

    @Override
    public boolean isFromWorld() {
        return this.target != null;
    }

    public ResourceLocation getId() {
        return Utils.getID(this);
    }

    @Override
    @Nullable
    public CustomMapDecoration loadDecorationFromBuffer(FriendlyByteBuf buffer) {
        try {
            return new CustomMapDecoration(this, buffer);
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to load custom map decoration for decoration type" + String.valueOf(this.getId()) + ": " + String.valueOf(e));
            return null;
        }
    }

    @Override
    @Nullable
    public SimpleMapBlockMarker loadMarkerFromNBT(CompoundTag compound) {
        SimpleMapBlockMarker marker = new SimpleMapBlockMarker(this);
        try {
            marker.loadFromNBT(compound);
            return marker;
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to load world map marker for decoration type" + String.valueOf(this.getId()) + ": " + String.valueOf(e));
            return null;
        }
    }

    @Override
    @Nullable
    public SimpleMapBlockMarker getWorldMarkerFromWorld(BlockGetter reader, BlockPos pos) {
        if (this.target != null && this.enabled && this.target.m_213865_(reader.m_8055_(pos), RandomSource.m_216327_())) {
            SimpleMapBlockMarker m = this.createEmptyMarker();
            m.setPos(pos);
            return m;
        }
        return null;
    }

    @Override
    public SimpleMapBlockMarker createEmptyMarker() {
        SimpleMapBlockMarker m = new SimpleMapBlockMarker(this);
        m.setRotation(this.rotation);
        m.setName((Component)(this.name == null ? null : Component.m_237115_((String)this.name)));
        return m;
    }
}

