/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.block.base;

import com.finchy.pipeorgans.block.base.BaseBlockEntity;
import com.finchy.pipeorgans.init.AllBlockEntities;
import com.finchy.pipeorgans.init.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BaseBlock
extends Block
implements IBE<BaseBlockEntity>,
IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WALL = BooleanProperty.m_61465_((String)"wall");
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public BaseBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WALL, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (Boolean)pState.m_61143_((Property)WALL) == false ? AllShapes.BASE_FLOOR : AllShapes.getBlockBase((Direction)pState.m_61143_((Property)FACING));
    }

    public Class<BaseBlockEntity> getBlockEntityClass() {
        return BaseBlockEntity.class;
    }

    public BlockEntityType<? extends BaseBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntities.BASE_BLOCK_ENTITY.get();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, WALL, POWERED});
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return FluidTankBlock.isTank((BlockState)pLevel.m_8055_(pPos.m_121945_(BaseBlock.getAttachedDirection(pState))));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state;
        Level level = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        Direction face = context.m_43719_();
        boolean wall = true;
        if (face.m_122434_() == Direction.Axis.Y) {
            face = context.m_8125_().m_122424_();
            wall = false;
        }
        if (!this.m_7898_(state = (BlockState)((BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)face.m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(level.m_276867_(clickedPos)))).m_61124_((Property)WALL, (Comparable)Boolean.valueOf(wall)), (LevelReader)level, clickedPos)) {
            return null;
        }
        return state;
    }

    public static Direction getAttachedDirection(BlockState state) {
        return (Boolean)state.m_61143_((Property)WALL) != false ? (Direction)state.m_61143_((Property)FACING) : Direction.DOWN;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.f_46443_) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.m_61143_((Property)POWERED);
        if (previouslyPowered != worldIn.m_276867_(pos)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
        }
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return BaseBlock.getAttachedDirection(pState) == pFacing && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : pState;
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        FluidTankBlock.updateBoilerState((BlockState)pState, (Level)pLevel, (BlockPos)pPos.m_121945_(BaseBlock.getAttachedDirection(pState)));
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        FluidTankBlock.updateBoilerState((BlockState)pState, (Level)pLevel, (BlockPos)pPos.m_121945_(BaseBlock.getAttachedDirection(pState)));
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        return originalState;
    }
}

