/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.block.pipes.generic;

import com.finchy.pipeorgans.block.Generic;
import com.finchy.pipeorgans.block.pipes.generic.GenericExtensionBlock;
import com.finchy.pipeorgans.block.pipes.generic.GenericPipeBlock;
import com.finchy.pipeorgans.block.pipes.generic.PedalExtensionBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PedalPipeBlock
extends GenericPipeBlock {
    public PedalPipeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WALL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SIZE, (Comparable)((Object)Generic.WhistleSize.LARGE)));
        this.extensionsPerBlock = 1;
    }

    @Override
    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        return originalState.m_61143_((Property)SIZE) == Generic.WhistleSize.HUGE ? (BlockState)originalState.m_61124_((Property)SIZE, (Comparable)((Object)Generic.WhistleSize.SMALL)) : (BlockState)originalState.m_61122_((Property)SIZE);
    }

    @Override
    public void incrementSize(LevelAccessor pLevel, BlockPos pPos, boolean playSound) {
        BlockState base = pLevel.m_8055_(pPos);
        if (!base.m_61138_((Property)SIZE)) {
            return;
        }
        Generic.WhistleSize size = (Generic.WhistleSize)((Object)base.m_61143_((Property)SIZE));
        SoundType soundtype = base.m_60827_();
        BlockPos currentPos = pPos.m_7494_();
        Direction facing = (Direction)base.m_61143_((Property)FACING);
        float pVolume = (soundtype.m_56773_() + 1.0f) / 2.0f;
        SoundEvent growSound = (SoundEvent)SoundEvents.f_12218_.get();
        SoundEvent hitSound = soundtype.m_56778_();
        for (int i = 1; i <= 12; ++i) {
            BlockState blockState = pLevel.m_8055_(currentPos);
            if (!(blockState.m_60734_() instanceof PedalExtensionBlock)) {
                if (!blockState.m_247087_()) {
                    return;
                }
                pLevel.m_7731_(currentPos, (BlockState)((BlockState)((GenericExtensionBlock)((Object)this.extensionBlock.get())).m_49966_().m_61124_((Property)SIZE, (Comparable)((Object)size))).m_61124_((Property)FACING, (Comparable)facing), 3);
                if (playSound) {
                    float pPitch = (float)Math.pow(2.0, (double)(-i) / 12.0);
                    pLevel.m_5594_(null, currentPos, growSound, SoundSource.BLOCKS, pVolume / 4.0f, pPitch);
                    pLevel.m_5594_(null, currentPos, hitSound, SoundSource.BLOCKS, pVolume, pPitch);
                }
                return;
            }
            currentPos = currentPos.m_7494_();
        }
    }
}

