/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.block.pipes.nasard;

import com.finchy.pipeorgans.ClientConfig;
import com.finchy.pipeorgans.block.Generic;
import com.finchy.pipeorgans.block.pipes.generic.GenericPipeBlockEntity;
import com.finchy.pipeorgans.block.pipes.nasard.NasardSoundInstance;
import com.finchy.pipeorgans.init.AllBlockEntities;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class NasardBlockEntity
extends GenericPipeBlockEntity {
    @OnlyIn(value=Dist.CLIENT)
    protected NasardSoundInstance soundInstance;

    public NasardBlockEntity(BlockPos pos, BlockState blockState) {
        super(pos, blockState, AllBlockEntities.NASARD_BLOCK_ENTITY);
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        String[] pitches = CreateLang.translateDirect((String)"generic.notes", (Object[])new Object[0]).getString().split(";");
        int displayPitch = ClientConfig.displayMutationSoundingPitch ? this.pitch + 5 : this.pitch;
        CreateLang.translate((String)"generic.pitch", (Object[])new Object[]{pitches[displayPitch % 12 % pitches.length]}).forGoggles(tooltip);
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void tickAudio(Generic.WhistleSize size, boolean powered) {
        if (!powered) {
            if (this.soundInstance != null) {
                this.soundInstance.fadeOut();
                this.soundInstance = null;
            }
            return;
        }
        float f = (float)Math.pow(2.0, (double)(-this.pitch) / 12.0);
        boolean particle = this.f_58857_.m_46467_() % 8L == 0L;
        Vec3 eyePosition = Minecraft.m_91087_().f_91075_.m_146892_();
        float maxVolume = (float)Mth.m_14008_((double)((64.0 - eyePosition.m_82554_(Vec3.m_82512_((Vec3i)this.f_58858_))) / 64.0), (double)0.0, (double)1.0);
        if (this.soundInstance == null || this.soundInstance.m_7801_() || this.soundInstance.getOctave() != size) {
            this.soundInstance = new NasardSoundInstance(size, this.f_58858_);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.soundInstance);
            AllSoundEvents.WHISTLE_CHIFF.playAt(this.f_58857_, (Vec3i)this.f_58858_, maxVolume * 0.1f, f, false);
            particle = true;
        }
        this.soundInstance.keepAlive();
        this.soundInstance.setPitch(f);
        if (!particle) {
            return;
        }
        this.createSteamJet(size);
    }
}

