/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.block.pipes.vox_humana;

import com.finchy.pipeorgans.block.Generic;
import com.finchy.pipeorgans.block.pipes.generic.GenericPipeBlock;
import com.finchy.pipeorgans.block.pipes.generic.ReedBlockEntity;
import com.finchy.pipeorgans.block.pipes.vox_humana.VoxHumanaSoundInstance;
import com.finchy.pipeorgans.init.AllBlockEntities;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.steamEngine.SteamJetParticleData;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VoxHumanaBlockEntity
extends ReedBlockEntity {
    @OnlyIn(value=Dist.CLIENT)
    protected VoxHumanaSoundInstance soundInstance;

    public VoxHumanaBlockEntity(BlockPos pos, BlockState blockState) {
        super(pos, blockState, AllBlockEntities.VOX_HUMANA_BLOCK_ENTITY);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void tickAudio(Generic.WhistleSize size, boolean powered) {
        if (!powered) {
            if (this.soundInstance != null) {
                this.soundInstance.fadeOut();
                this.soundInstance = null;
            }
            return;
        }
        float f = (float)Math.pow(2.0, (double)(-this.pitch) / 12.0);
        boolean particle = this.f_58857_.m_46467_() % 8L == 0L;
        Vec3 eyePosition = Minecraft.m_91087_().f_91075_.m_146892_();
        float maxVolume = (float)Mth.m_14008_((double)((64.0 - eyePosition.m_82554_(Vec3.m_82512_((Vec3i)this.f_58858_))) / 64.0), (double)0.0, (double)1.0);
        if (this.soundInstance == null || this.soundInstance.m_7801_() || this.soundInstance.getOctave() != size) {
            this.soundInstance = new VoxHumanaSoundInstance(size, this.f_58858_);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.soundInstance);
            AllSoundEvents.WHISTLE_CHIFF.playAt(this.f_58857_, (Vec3i)this.f_58858_, maxVolume * 0.1f, f, false);
            particle = true;
        }
        this.soundInstance.keepAlive();
        this.soundInstance.setPitch(f);
        if (!particle) {
            return;
        }
        this.createSteamJet(size);
    }

    @Override
    public void createSteamJet(Generic.WhistleSize size) {
        Direction facing = this.m_58900_().m_61145_((Property)GenericPipeBlock.FACING).orElse(Direction.SOUTH);
        float angle = 180.0f + AngleHelper.horizontalAngle((Direction)facing);
        float yOffset = this.pitch == 0 ? 0.125f : 0.0f;
        double yPos = (double)this.pitch / 4.0 + 1.0 + (double)yOffset;
        if (size == Generic.WhistleSize.TINY) {
            size = Generic.WhistleSize.SMALL;
        }
        double zOffset = (double)(0.125f * (float)size.ordinal()) + (this.pitch == 0 ? 0.0 : 0.0625);
        Vec3 v = VecHelper.rotate((Vec3)new Vec3(0.0, yPos, zOffset), (double)angle, (Direction.Axis)Direction.Axis.Y).m_82549_(Vec3.m_82539_((Vec3i)this.f_58858_));
        Vec3 m = VecHelper.rotate((Vec3)new Vec3(0.0, 1.0, 1.0), (double)angle, (Direction.Axis)Direction.Axis.Y);
        this.f_58857_.m_7106_((ParticleOptions)new SteamJetParticleData(1.0f), v.f_82479_, v.f_82480_, v.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
    }
}

