/*
 * Decompiled with CFR 0.152.
 */
package com.probejs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.probejs.ProbeJS;
import com.probejs.ProbePaths;
import dev.latvian.mods.kubejs.KubeJSPaths;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Function;

public class ProbeConfig {
    public static final int MOD_COUNT = 350;
    public static ProbeConfig INSTANCE = new ProbeConfig();
    private static final int CONFIG_VERSION = 2;
    public boolean firstLoad = true;
    private static final String FIRST_LOAD_KEY = "Is ProbeJS Loaded for First Time in the Modpack - Configured by ProbeJS Itself";
    public boolean noAggressiveProbing = false;
    private static final String NO_AGGRESSIVE_PROBING_KEY = "Disable Aggressive Mode for ProbeJS Dumps";
    public long docsTimestamp = 0L;
    private static final String DOCS_TIMESTAMP_KEY = "The Timestamp of ProbeJS Remote Documents - Configured by ProbeJS Itself";
    public boolean allowRegistryObjectDumps = true;
    private static final String ALLOW_REGISTRY_OBJECT_DUMPS_KEY = "Allow ProbeJS to Resolve Classes from Registries Like Item Classes or Block Classes";
    public boolean allowRegistryLiteralDumps = true;
    private static final String ALLOW_REGISTRY_LITERAL_DUMPS_KEY = "Allow ProbeJS to Generate Literal Types for Item/Block/etc. IDs";
    public boolean requireSingleAndPerm = true;
    private static final String REQUIRE_SINGLE_AND_PERM_KEY = "Should ProbeJS Only Show Command in Single Player and with Cheat Enabled";
    public boolean enabled = true;
    private static final String ENABLED_KEY = "Should ProbeJS be Generally Enabled";
    public boolean modChanged = false;
    public boolean disableRecipeJsonDump = true;
    private static final String DISABLE_RECIPE_JSON_DUMP_KEY = "Disable the Recipe JSON Snippet Generation for ProbeJS triggered by `#`";
    public boolean dumpJSONIntermediates = false;
    private static final String DUMP_JSON_INTERMEDIATES_KEY = "Should ProbeJS Generate Intermediate JSON Representation of Documents - Mostly for Debugging";
    public boolean pullSchema = false;
    private static final String PULL_SCHEMA_KEY = "Should ProbeJS Download Schema Scripts from Github for Mods without Addon Supports";
    public int interactive = 0;
    private static final String INTERACTIVE_KEY = "Should ProbeJS Open the Websocket for VSCode Evaluation? 1 - enabled, others - disabled.";
    public int interactivePort = 7796;
    private static final String INTERACTIVE_PORT_KEY = "Which port should ProbeJS listen on for VSCode Extension?";

    private static <E> E fetchPropertyOrDefault(Object key, Map<?, ?> value, E defaultValue, Function<Object, E> transformer) {
        if (value == null || !value.containsKey("version") || (Double)value.get("version") < 2.0) {
            ProbeJS.LOGGER.warn("Config version has changed! Config values are rolled back to default.");
            return defaultValue;
        }
        Object v = value.get(key);
        try {
            return v == null ? defaultValue : transformer.apply(v);
        }
        catch (Exception ignored) {
            return defaultValue;
        }
    }

    private static <E> E fetchPropertyOrDefault(Object key, Map<?, ?> value, E defaultValue) {
        return (E)ProbeConfig.fetchPropertyOrDefault(key, value, defaultValue, e -> e);
    }

    private ProbeConfig() {
        Path cfg = KubeJSPaths.CONFIG.resolve("probejs.json");
        if (Files.exists(cfg, new LinkOption[0])) {
            try {
                Map obj = (Map)ProbeJS.GSON.fromJson((Reader)Files.newBufferedReader(cfg), Map.class);
                this.firstLoad = ProbeConfig.fetchPropertyOrDefault(FIRST_LOAD_KEY, obj, true);
                this.docsTimestamp = ProbeConfig.fetchPropertyOrDefault(DOCS_TIMESTAMP_KEY, obj, 0.0).longValue();
                this.noAggressiveProbing = ProbeConfig.fetchPropertyOrDefault(NO_AGGRESSIVE_PROBING_KEY, obj, false);
                this.allowRegistryObjectDumps = ProbeConfig.fetchPropertyOrDefault(ALLOW_REGISTRY_OBJECT_DUMPS_KEY, obj, true);
                this.allowRegistryLiteralDumps = ProbeConfig.fetchPropertyOrDefault(ALLOW_REGISTRY_LITERAL_DUMPS_KEY, obj, true);
                this.requireSingleAndPerm = ProbeConfig.fetchPropertyOrDefault(REQUIRE_SINGLE_AND_PERM_KEY, obj, true);
                this.enabled = ProbeConfig.fetchPropertyOrDefault(ENABLED_KEY, obj, true);
                this.disableRecipeJsonDump = ProbeConfig.fetchPropertyOrDefault(DISABLE_RECIPE_JSON_DUMP_KEY, obj, true);
                this.dumpJSONIntermediates = ProbeConfig.fetchPropertyOrDefault(DUMP_JSON_INTERMEDIATES_KEY, obj, false);
                this.pullSchema = ProbeConfig.fetchPropertyOrDefault(PULL_SCHEMA_KEY, obj, false);
                this.interactive = ProbeConfig.fetchPropertyOrDefault(INTERACTIVE_KEY, obj, 0.0).intValue();
                this.interactivePort = ProbeConfig.fetchPropertyOrDefault(INTERACTIVE_PORT_KEY, obj, 7796.0).intValue();
            }
            catch (Exception e) {
                ProbeJS.LOGGER.warn("Cannot read config properties, falling back to defaults.");
                e.printStackTrace();
            }
        }
        this.save();
    }

    public void save() {
        Path cfg = KubeJSPaths.CONFIG.resolve("probejs.json");
        try (BufferedWriter writer = Files.newBufferedWriter(cfg, new OpenOption[0]);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonObject jObj = new JsonObject();
            jObj.addProperty("version", (Number)2);
            jObj.addProperty(FIRST_LOAD_KEY, Boolean.valueOf(this.firstLoad));
            jObj.addProperty(DOCS_TIMESTAMP_KEY, (Number)this.docsTimestamp);
            jObj.addProperty(NO_AGGRESSIVE_PROBING_KEY, Boolean.valueOf(this.noAggressiveProbing));
            jObj.addProperty(ALLOW_REGISTRY_OBJECT_DUMPS_KEY, Boolean.valueOf(this.allowRegistryObjectDumps));
            jObj.addProperty(ALLOW_REGISTRY_LITERAL_DUMPS_KEY, Boolean.valueOf(this.allowRegistryLiteralDumps));
            jObj.addProperty(REQUIRE_SINGLE_AND_PERM_KEY, Boolean.valueOf(this.requireSingleAndPerm));
            jObj.addProperty(ENABLED_KEY, Boolean.valueOf(this.enabled));
            jObj.addProperty(DISABLE_RECIPE_JSON_DUMP_KEY, Boolean.valueOf(this.disableRecipeJsonDump));
            jObj.addProperty(DUMP_JSON_INTERMEDIATES_KEY, Boolean.valueOf(this.dumpJSONIntermediates));
            jObj.addProperty(PULL_SCHEMA_KEY, Boolean.valueOf(this.pullSchema));
            jObj.addProperty(INTERACTIVE_KEY, (Number)this.interactive);
            jObj.addProperty(INTERACTIVE_PORT_KEY, (Number)this.interactivePort);
            gson.toJson((JsonElement)jObj, (Appendable)writer);
        }
        catch (IOException e) {
            ProbeJS.LOGGER.warn("Cannot write config, settings are not saved.");
        }
    }

    public boolean toggleAggressiveProbing() {
        this.noAggressiveProbing = !this.noAggressiveProbing;
        return this.noAggressiveProbing;
    }

    public boolean shouldProbingAggressive() {
        return !this.noAggressiveProbing && this.enabled;
    }

    public static String getModHash() {
        Path hashFile = ProbePaths.CACHE.resolve("modHash.txt");
        if (Files.exists(hashFile, new LinkOption[0])) {
            try {
                return Files.readString(hashFile);
            }
            catch (IOException e) {
                ProbeJS.LOGGER.warn("Cannot read mod hash file, falling back to default.");
            }
        }
        return "0";
    }

    public static void writeModHash(String hash) {
        Path hashFile = ProbePaths.CACHE.resolve("modHash.txt");
        try {
            Files.writeString(hashFile, (CharSequence)hash, new OpenOption[0]);
        }
        catch (IOException e) {
            ProbeJS.LOGGER.warn("Cannot write mod hash file, settings are not saved.");
        }
    }

    public static void reload() {
        INSTANCE = new ProbeConfig();
    }
}

