/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.docs.formatter;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.probejs.ProbeJS;
import com.probejs.docs.formatter.SpecialTypes;
import com.probejs.jdoc.document.DocumentClass;
import com.probejs.jdoc.java.ClassInfo;
import com.probejs.jdoc.java.MethodInfo;
import com.probejs.jdoc.java.type.ITypeInfo;
import dev.latvian.mods.rhino.util.RemapForJS;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.damagesource.DamageSource;

public class NameResolver {
    public static final HashMap<String, List<ResolvedName>> resolvedNames = new HashMap();
    public static final HashMap<Class<?>, Function<ITypeInfo, String>> specialTypeFormatters = new HashMap();
    public static final HashMap<Class<?>, Boolean> specialTypeGuards = new HashMap();
    public static final Multimap<String, Supplier<List<String>>> specialClassAssigner = ArrayListMultimap.create();
    public static final List<String> nameResolveSpecials = new ArrayList<String>();
    public static final Set<String> keywords = new HashSet<String>();
    public static final Set<String> resolvedPrimitives = new HashSet<String>();

    public static void clear() {
        resolvedNames.clear();
        specialTypeFormatters.clear();
        specialTypeGuards.clear();
        specialClassAssigner.clear();
        nameResolveSpecials.clear();
        keywords.clear();
        resolvedPrimitives.clear();
    }

    public static void putResolvedName(String className, String resolvedName) {
        NameResolver.putResolvedName(className, new ResolvedName(Arrays.stream(resolvedName.split("\\.")).toList()));
    }

    public static void putResolvedName(String className, ResolvedName resolvedName) {
        List resolvedNameList = resolvedNames.computeIfAbsent(className, s -> new ArrayList());
        if (!resolvedNameList.contains(resolvedName)) {
            resolvedNameList.add(resolvedName);
        }
    }

    public static void putResolvedName(Class<?> className, ResolvedName resolvedName) {
        String remappedName = ClassInfo.getOrCache(className).getName();
        NameResolver.putResolvedName(remappedName, resolvedName);
    }

    public static void putResolvedName(Class<?> className, String resolvedName) {
        if (className.isAnnotationPresent(RemapForJS.class)) {
            resolvedName = className.getAnnotation(RemapForJS.class).value();
        }
        NameResolver.putResolvedName(className, new ResolvedName(Arrays.stream(resolvedName.split("\\.")).toList()));
    }

    @MethodsReturnNonnullByDefault
    public static ResolvedName getResolvedName(String className) {
        List<ResolvedName> names = resolvedNames.get(className);
        if (names == null || names.size() == 0) {
            return ResolvedName.UNRESOLVED;
        }
        return names.get(0);
    }

    public static void putTypeFormatter(Class<?> className, Function<ITypeInfo, String> formatter) {
        specialTypeFormatters.put(className, formatter);
    }

    public static void putTypeGuard(boolean isSafe, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            specialTypeGuards.put(clazz, isSafe);
        }
    }

    public static boolean isTypeSpecial(Class<?> clazz) {
        return specialTypeFormatters.containsKey(clazz);
    }

    public static boolean findResolvedName(ResolvedName name) {
        return resolvedNames.values().stream().anyMatch(names -> names.contains(name));
    }

    public static void resolveName(DocumentClass document) {
        String name = document.getName();
        if (resolvedNames.containsKey(name)) {
            return;
        }
        ResolvedName resolved = new ResolvedName(Arrays.stream(name.split("\\.")).toList());
        ResolvedName internal = new ResolvedName(List.of("Internal", resolved.getLastName()));
        if (NameResolver.findResolvedName(internal)) {
            NameResolver.putResolvedName(name, resolved);
        } else {
            NameResolver.putResolvedName(name, internal);
        }
    }

    public static void addKeyword(String kw) {
        keywords.add(kw);
    }

    public static String getNameSafe(String kw) {
        return keywords.contains(kw) ? kw + "_" : kw;
    }

    public static void putResolvedPrimitive(Class<?> clazz, String resolvedName) {
        NameResolver.putResolvedName(clazz.getName(), resolvedName);
        resolvedPrimitives.add(clazz.getName());
    }

    public static void putSpecialAssignments(Class<?> clazz, Supplier<List<String>> assigns) {
        specialClassAssigner.put((Object)MethodInfo.getRemappedOrOriginalClass(clazz), assigns);
    }

    public static List<String> getClassAssignments(String clazz) {
        ArrayList<String> assignables = new ArrayList<String>();
        specialClassAssigner.get((Object)clazz).stream().map(Supplier::get).forEach(assignables::addAll);
        return assignables;
    }

    public static void addPrioritizedPackage(String prior) {
        nameResolveSpecials.add(prior + ".");
    }

    public static List<DocumentClass> priorSortClasses(Iterable<DocumentClass> classes) {
        ArrayListMultimap partMap = ArrayListMultimap.create();
        for (DocumentClass clazz : classes) {
            int index = -1;
            String name = clazz.getName();
            for (int i = 0; i < nameResolveSpecials.size(); ++i) {
                if (!name.startsWith(nameResolveSpecials.get(i))) continue;
                index = i;
            }
            partMap.put((Object)index, (Object)clazz);
        }
        ArrayList<DocumentClass> result = new ArrayList<DocumentClass>();
        for (int i = 0; i < nameResolveSpecials.size(); ++i) {
            if (!partMap.containsKey((Object)i)) continue;
            result.addAll(partMap.get((Object)i));
        }
        if (partMap.containsKey((Object)-1)) {
            result.addAll(partMap.get((Object)-1));
        }
        return result;
    }

    public static void init() {
        NameResolver.clear();
        NameResolver.putResolvedPrimitive(Object.class, "any");
        NameResolver.putResolvedPrimitive(String.class, "string");
        NameResolver.putResolvedPrimitive(Character.class, "string");
        NameResolver.putResolvedPrimitive(Character.TYPE, "string");
        NameResolver.putResolvedPrimitive(Void.class, "void");
        NameResolver.putResolvedPrimitive(Void.TYPE, "void");
        NameResolver.putResolvedPrimitive(Long.class, "number");
        NameResolver.putResolvedPrimitive(Long.TYPE, "number");
        NameResolver.putResolvedPrimitive(Integer.class, "number");
        NameResolver.putResolvedPrimitive(Integer.TYPE, "number");
        NameResolver.putResolvedPrimitive(Short.class, "number");
        NameResolver.putResolvedPrimitive(Short.TYPE, "number");
        NameResolver.putResolvedPrimitive(Byte.class, "number");
        NameResolver.putResolvedPrimitive(Byte.TYPE, "number");
        NameResolver.putResolvedPrimitive(Number.class, "number");
        NameResolver.putResolvedPrimitive(Double.class, "number");
        NameResolver.putResolvedPrimitive(Double.TYPE, "number");
        NameResolver.putResolvedPrimitive(Float.class, "number");
        NameResolver.putResolvedPrimitive(Float.TYPE, "number");
        NameResolver.putResolvedPrimitive(Boolean.class, "boolean");
        NameResolver.putResolvedPrimitive(Boolean.TYPE, "boolean");
        NameResolver.putSpecialAssignments(DamageSource.class, () -> {
            ArrayList<String> result = new ArrayList<String>();
            try {
                for (Field field : DamageSource.class.getDeclaredFields()) {
                    field.setAccessible(true);
                    if (!Modifier.isStatic(field.getModifiers()) || field.getType() != DamageSource.class) continue;
                    result.add(ProbeJS.GSON.toJson((Object)((DamageSource)field.get(null)).m_19385_()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        });
        SpecialTypes.assignRegistries();
        NameResolver.addKeyword("function");
        NameResolver.addKeyword("debugger");
        NameResolver.addKeyword("in");
        NameResolver.addKeyword("with");
        NameResolver.addKeyword("java");
        NameResolver.addKeyword("var");
        NameResolver.addKeyword("const");
        NameResolver.addPrioritizedPackage("java");
        NameResolver.addPrioritizedPackage("dev.latvian.mods");
        NameResolver.addPrioritizedPackage("net.minecraft");
        NameResolver.addPrioritizedPackage("net.minecraftforge");
    }

    public static class ResolvedName {
        public static final ResolvedName UNRESOLVED = new ResolvedName(List.of("any"));
        private final List<String> names;

        public ResolvedName(List<String> names) {
            this.names = names.stream().map(NameResolver::getNameSafe).collect(Collectors.toList());
        }

        public String getFullName() {
            return String.join((CharSequence)".", this.names);
        }

        public String getNamespace() {
            return String.join((CharSequence)".", this.names.subList(0, this.names.size() - 1));
        }

        public String getLastName() {
            return this.names.get(this.names.size() - 1);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolvedName that = (ResolvedName)o;
            return this.names.equals(that.names);
        }

        public int hashCode() {
            return Objects.hash(this.names);
        }

        public String toString() {
            return "ResolvedName{names=" + this.names + "}";
        }
    }
}

