/*
 * Decompiled with CFR 0.152.
 */
package com.akciater;

import com.akciater.blocks.FloorShelf;
import com.akciater.blocks.FloorShelfBlockEntity;
import com.akciater.blocks.Shelf;
import com.akciater.blocks.ShelfBlockEntity;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;

public final class ShelfModCommon {
    public static final String MODID = "shelfmod";
    public static final Supplier<RegistrarManager> MANAGER = Suppliers.memoize(() -> RegistrarManager.get((String)MODID));
    public static final Registrar<Block> blocks = MANAGER.get().get(Registries.f_256747_);
    public static final Registrar<Item> items = MANAGER.get().get(Registries.f_256913_);
    public static final Registrar<BlockEntityType<?>> blockEntities = MANAGER.get().get(Registries.f_256922_);
    public static final Registrar<CreativeModeTab> itemGroups = MANAGER.get().get(Registries.f_279569_);
    public static RegistrySupplier<Item> ICON;
    public static RegistrySupplier<Block> SHELF_OAK;
    public static RegistrySupplier<Block> FLOOR_SHELF_OAK;
    public static RegistrySupplier<Block> SHELF_ACACIA;
    public static RegistrySupplier<Block> FLOOR_SHELF_ACACIA;
    public static RegistrySupplier<Block> SHELF_BIRCH;
    public static RegistrySupplier<Block> FLOOR_SHELF_BIRCH;
    public static RegistrySupplier<Block> SHELF_DARK_OAK;
    public static RegistrySupplier<Block> FLOOR_SHELF_DARK_OAK;
    public static RegistrySupplier<Block> SHELF_SPRUCE;
    public static RegistrySupplier<Block> FLOOR_SHELF_SPRUCE;
    public static RegistrySupplier<Block> SHELF_JUNGLE;
    public static RegistrySupplier<Block> FLOOR_SHELF_JUNGLE;
    public static RegistrySupplier<Block> SHELF_MANGROVE;
    public static RegistrySupplier<Block> FLOOR_SHELF_MANGROVE;
    public static RegistrySupplier<Block> SHELF_BAMBOO;
    public static RegistrySupplier<Block> FLOOR_SHELF_BAMBOO;
    public static RegistrySupplier<Block> SHELF_WARPED;
    public static RegistrySupplier<Block> FLOOR_SHELF_WARPED;
    public static RegistrySupplier<Block> SHELF_CHERRY;
    public static RegistrySupplier<Block> FLOOR_SHELF_CHERRY;
    public static RegistrySupplier<Block> SHELF_CRIMSON;
    public static RegistrySupplier<Block> FLOOR_SHELF_CRIMSON;
    public static RegistrySupplier<Item> SHELF_ITEM_OAK;
    public static RegistrySupplier<Item> FLOOR_SHELF_ITEM_OAK;
    public static RegistrySupplier<Item> SHELF_ITEM_ACACIA;
    public static RegistrySupplier<Item> FLOOR_SHELF_ITEM_ACACIA;
    public static RegistrySupplier<Item> SHELF_ITEM_BIRCH;
    public static RegistrySupplier<Item> FLOOR_SHELF_ITEM_BIRCH;
    public static RegistrySupplier<Item> SHELF_ITEM_DARK_OAK;
    public static RegistrySupplier<Item> FLOOR_SHELF_ITEM_DARK_OAK;
    public static RegistrySupplier<Item> SHELF_ITEM_SPRUCE;
    public static RegistrySupplier<Item> FLOOR_SHELF_ITEM_SPRUCE;
    public static RegistrySupplier<Item> SHELF_ITEM_JUNGLE;
    public static RegistrySupplier<Item> FLOOR_SHELF_ITEM_JUNGLE;
    public static RegistrySupplier<Item> SHELF_ITEM_MANGROVE;
    public static RegistrySupplier<Item> FLOOR_SHELF_ITEM_MANGROVE;
    public static RegistrySupplier<Item> SHELF_ITEM_BAMBOO;
    public static RegistrySupplier<Item> FLOOR_SHELF_ITEM_BAMBOO;
    public static RegistrySupplier<Item> SHELF_ITEM_WARPED;
    public static RegistrySupplier<Item> FLOOR_SHELF_ITEM_WARPED;
    public static RegistrySupplier<Item> SHELF_ITEM_CHERRY;
    public static RegistrySupplier<Item> FLOOR_SHELF_ITEM_CHERRY;
    public static RegistrySupplier<Item> SHELF_ITEM_CRIMSON;
    public static RegistrySupplier<Item> FLOOR_SHELF_ITEM_CRIMSON;
    public static RegistrySupplier<BlockEntityType<ShelfBlockEntity>> SHELF_BLOCK_ENTITY;
    public static RegistrySupplier<BlockEntityType<FloorShelfBlockEntity>> FLOOR_SHELF_BLOCK_ENTITY;
    public static RegistrySupplier<CreativeModeTab> SHELF_MOD_TAB;
    public static List<RegistrySupplier<Item>> SHELVES;
    public static List<JsonObject> SHELVES_JSON;
    public static List<String> MATERIALS;

    public static boolean isShelf(Item item) {
        for (RegistrySupplier<Item> shelf : SHELVES) {
            if (shelf.get() != item) continue;
            return true;
        }
        return false;
    }

    public static JsonObject createShapedRecipeJson(ArrayList<Character> keys, ArrayList<ResourceLocation> items, ArrayList<String> type, ArrayList<String> pattern, ResourceLocation output) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shaped");
        JsonArray jsonArray = new JsonArray();
        jsonArray.add(pattern.get(0));
        jsonArray.add(pattern.get(1));
        jsonArray.add(pattern.get(2));
        json.add("pattern", (JsonElement)jsonArray);
        JsonObject keyList = new JsonObject();
        for (int i = 0; i < keys.size(); ++i) {
            JsonObject individualKey = new JsonObject();
            individualKey.addProperty(type.get(i), items.get(i).toString());
            keyList.add("" + keys.get(i), (JsonElement)individualKey);
        }
        json.add("key", (JsonElement)keyList);
        JsonObject result = new JsonObject();
        result.addProperty("item", output.toString());
        result.addProperty("count", (Number)1);
        json.add("result", (JsonElement)result);
        return json;
    }

    public static JsonObject createShelfRecipe(String material) {
        ResourceLocation shelf = new ResourceLocation(MODID, "shelf_item_" + material);
        return ShelfModCommon.createShapedRecipeJson(Lists.newArrayList((Object[])new Character[]{Character.valueOf('#'), Character.valueOf('_')}), Lists.newArrayList((Object[])new ResourceLocation[]{new ResourceLocation(material + "_fence"), new ResourceLocation(material + "_slab")}), Lists.newArrayList((Object[])new String[]{"item", "item"}), Lists.newArrayList((Object[])new String[]{"___", "# #", "___"}), shelf);
    }

    public static JsonObject createFloorShelfRecipe(String material) {
        ResourceLocation shelf = new ResourceLocation(MODID, "floor_shelf_item_" + material);
        return ShelfModCommon.createShapedRecipeJson(Lists.newArrayList((Object[])new Character[]{Character.valueOf('#'), Character.valueOf('@')}), Lists.newArrayList((Object[])new ResourceLocation[]{new ResourceLocation(material + "_fence"), new ResourceLocation(material + "_planks")}), Lists.newArrayList((Object[])new String[]{"item", "item"}), Lists.newArrayList((Object[])new String[]{"@#@", "#@#", "@#@"}), shelf);
    }

    public static void initializeServer() {
        ICON = items.register(new ResourceLocation(MODID, "icon"), () -> new Item(new Item.Properties()));
        SHELF_MOD_TAB = itemGroups.register(new ResourceLocation(MODID, "shelf_mod_tab"), () -> CreativeTabRegistry.create((Component)Component.m_237113_((String)"Shelf mod"), () -> ((Item)ICON.get()).m_5456_().m_7968_()));
        SHELF_OAK = blocks.register(new ResourceLocation(MODID, "shelf_oak"), () -> new Shelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
        FLOOR_SHELF_OAK = blocks.register(new ResourceLocation(MODID, "floor_shelf_oak"), () -> new FloorShelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
        SHELF_ACACIA = blocks.register(new ResourceLocation(MODID, "shelf_acacia"), () -> new Shelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
        FLOOR_SHELF_ACACIA = blocks.register(new ResourceLocation(MODID, "floor_shelf_acacia"), () -> new FloorShelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
        SHELF_BIRCH = blocks.register(new ResourceLocation(MODID, "shelf_birch"), () -> new Shelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
        FLOOR_SHELF_BIRCH = blocks.register(new ResourceLocation(MODID, "floor_shelf_birch"), () -> new FloorShelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
        SHELF_DARK_OAK = blocks.register(new ResourceLocation(MODID, "shelf_dark_oak"), () -> new Shelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
        FLOOR_SHELF_DARK_OAK = blocks.register(new ResourceLocation(MODID, "floor_shelf_dark_oak"), () -> new FloorShelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
        SHELF_SPRUCE = blocks.register(new ResourceLocation(MODID, "shelf_spruce"), () -> new Shelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
        FLOOR_SHELF_SPRUCE = blocks.register(new ResourceLocation(MODID, "floor_shelf_spruce"), () -> new FloorShelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
        SHELF_JUNGLE = blocks.register(new ResourceLocation(MODID, "shelf_jungle"), () -> new Shelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
        FLOOR_SHELF_JUNGLE = blocks.register(new ResourceLocation(MODID, "floor_shelf_jungle"), () -> new FloorShelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
        SHELF_MANGROVE = blocks.register(new ResourceLocation(MODID, "shelf_mangrove"), () -> new Shelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
        FLOOR_SHELF_MANGROVE = blocks.register(new ResourceLocation(MODID, "floor_shelf_mangrove"), () -> new FloorShelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
        SHELF_BAMBOO = blocks.register(new ResourceLocation(MODID, "shelf_bamboo"), () -> new Shelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
        FLOOR_SHELF_BAMBOO = blocks.register(new ResourceLocation(MODID, "floor_shelf_bamboo"), () -> new FloorShelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
        SHELF_WARPED = blocks.register(new ResourceLocation(MODID, "shelf_warped"), () -> new Shelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
        FLOOR_SHELF_WARPED = blocks.register(new ResourceLocation(MODID, "floor_shelf_warped"), () -> new FloorShelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
        SHELF_CHERRY = blocks.register(new ResourceLocation(MODID, "shelf_cherry"), () -> new Shelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
        FLOOR_SHELF_CHERRY = blocks.register(new ResourceLocation(MODID, "floor_shelf_cherry"), () -> new FloorShelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
        SHELF_CRIMSON = blocks.register(new ResourceLocation(MODID, "shelf_crimson"), () -> new Shelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
        FLOOR_SHELF_CRIMSON = blocks.register(new ResourceLocation(MODID, "floor_shelf_crimson"), () -> new FloorShelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
        SHELF_ITEM_OAK = items.register(new ResourceLocation(MODID, "shelf_item_oak"), () -> new BlockItem((Block)SHELF_OAK.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
        FLOOR_SHELF_ITEM_OAK = items.register(new ResourceLocation(MODID, "floor_shelf_item_oak"), () -> new BlockItem((Block)FLOOR_SHELF_OAK.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
        SHELF_ITEM_ACACIA = items.register(new ResourceLocation(MODID, "shelf_item_acacia"), () -> new BlockItem((Block)SHELF_ACACIA.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
        FLOOR_SHELF_ITEM_ACACIA = items.register(new ResourceLocation(MODID, "floor_shelf_item_acacia"), () -> new BlockItem((Block)FLOOR_SHELF_ACACIA.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
        SHELF_ITEM_BIRCH = items.register(new ResourceLocation(MODID, "shelf_item_birch"), () -> new BlockItem((Block)SHELF_BIRCH.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
        FLOOR_SHELF_ITEM_BIRCH = items.register(new ResourceLocation(MODID, "floor_shelf_item_birch"), () -> new BlockItem((Block)FLOOR_SHELF_BIRCH.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
        SHELF_ITEM_DARK_OAK = items.register(new ResourceLocation(MODID, "shelf_item_dark_oak"), () -> new BlockItem((Block)SHELF_DARK_OAK.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
        FLOOR_SHELF_ITEM_DARK_OAK = items.register(new ResourceLocation(MODID, "floor_shelf_item_dark_oak"), () -> new BlockItem((Block)FLOOR_SHELF_DARK_OAK.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
        SHELF_ITEM_SPRUCE = items.register(new ResourceLocation(MODID, "shelf_item_spruce"), () -> new BlockItem((Block)SHELF_SPRUCE.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
        FLOOR_SHELF_ITEM_SPRUCE = items.register(new ResourceLocation(MODID, "floor_shelf_item_spruce"), () -> new BlockItem((Block)FLOOR_SHELF_SPRUCE.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
        SHELF_ITEM_JUNGLE = items.register(new ResourceLocation(MODID, "shelf_item_jungle"), () -> new BlockItem((Block)SHELF_JUNGLE.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
        FLOOR_SHELF_ITEM_JUNGLE = items.register(new ResourceLocation(MODID, "floor_shelf_item_jungle"), () -> new BlockItem((Block)FLOOR_SHELF_JUNGLE.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
        SHELF_ITEM_MANGROVE = items.register(new ResourceLocation(MODID, "shelf_item_mangrove"), () -> new BlockItem((Block)SHELF_MANGROVE.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
        FLOOR_SHELF_ITEM_MANGROVE = items.register(new ResourceLocation(MODID, "floor_shelf_item_mangrove"), () -> new BlockItem((Block)FLOOR_SHELF_MANGROVE.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
        SHELF_ITEM_BAMBOO = items.register(new ResourceLocation(MODID, "shelf_item_bamboo"), () -> new BlockItem((Block)SHELF_BAMBOO.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
        FLOOR_SHELF_ITEM_BAMBOO = items.register(new ResourceLocation(MODID, "floor_shelf_item_bamboo"), () -> new BlockItem((Block)FLOOR_SHELF_BAMBOO.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
        SHELF_ITEM_WARPED = items.register(new ResourceLocation(MODID, "shelf_item_warped"), () -> new BlockItem((Block)SHELF_WARPED.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
        FLOOR_SHELF_ITEM_WARPED = items.register(new ResourceLocation(MODID, "floor_shelf_item_warped"), () -> new BlockItem((Block)FLOOR_SHELF_WARPED.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
        SHELF_ITEM_CHERRY = items.register(new ResourceLocation(MODID, "shelf_item_cherry"), () -> new BlockItem((Block)SHELF_CHERRY.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
        FLOOR_SHELF_ITEM_CHERRY = items.register(new ResourceLocation(MODID, "floor_shelf_item_cherry"), () -> new BlockItem((Block)FLOOR_SHELF_CHERRY.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
        SHELF_ITEM_CRIMSON = items.register(new ResourceLocation(MODID, "shelf_item_crimson"), () -> new BlockItem((Block)SHELF_CRIMSON.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
        FLOOR_SHELF_ITEM_CRIMSON = items.register(new ResourceLocation(MODID, "floor_shelf_item_crimson"), () -> new BlockItem((Block)FLOOR_SHELF_CRIMSON.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
        SHELF_BLOCK_ENTITY = blockEntities.register(new ResourceLocation(MODID, "shelf_block_entity"), () -> BlockEntityType.Builder.m_155273_(ShelfBlockEntity::new, (Block[])new Block[]{(Block)SHELF_OAK.get(), (Block)SHELF_ACACIA.get(), (Block)SHELF_BIRCH.get(), (Block)SHELF_DARK_OAK.get(), (Block)SHELF_SPRUCE.get(), (Block)SHELF_JUNGLE.get(), (Block)SHELF_MANGROVE.get(), (Block)SHELF_BAMBOO.get(), (Block)SHELF_WARPED.get(), (Block)SHELF_CHERRY.get(), (Block)SHELF_CRIMSON.get()}).m_58966_(null));
        FLOOR_SHELF_BLOCK_ENTITY = blockEntities.register(new ResourceLocation(MODID, "floor_shelf_block_entity"), () -> BlockEntityType.Builder.m_155273_(FloorShelfBlockEntity::new, (Block[])new Block[]{(Block)FLOOR_SHELF_OAK.get(), (Block)FLOOR_SHELF_ACACIA.get(), (Block)FLOOR_SHELF_BIRCH.get(), (Block)FLOOR_SHELF_DARK_OAK.get(), (Block)FLOOR_SHELF_SPRUCE.get(), (Block)FLOOR_SHELF_JUNGLE.get(), (Block)FLOOR_SHELF_MANGROVE.get(), (Block)FLOOR_SHELF_BAMBOO.get(), (Block)FLOOR_SHELF_WARPED.get(), (Block)FLOOR_SHELF_CHERRY.get(), (Block)FLOOR_SHELF_CRIMSON.get()}).m_58966_(null));
        SHELVES = List.of(SHELF_ITEM_OAK, FLOOR_SHELF_ITEM_OAK, SHELF_ITEM_ACACIA, FLOOR_SHELF_ITEM_ACACIA, SHELF_ITEM_BIRCH, FLOOR_SHELF_ITEM_BIRCH, SHELF_ITEM_DARK_OAK, FLOOR_SHELF_ITEM_DARK_OAK, SHELF_ITEM_SPRUCE, FLOOR_SHELF_ITEM_SPRUCE, SHELF_ITEM_JUNGLE, FLOOR_SHELF_ITEM_JUNGLE, SHELF_ITEM_MANGROVE, FLOOR_SHELF_ITEM_MANGROVE, SHELF_ITEM_BAMBOO, FLOOR_SHELF_ITEM_BAMBOO, SHELF_ITEM_WARPED, FLOOR_SHELF_ITEM_WARPED, SHELF_ITEM_CHERRY, FLOOR_SHELF_ITEM_CHERRY, SHELF_ITEM_CRIMSON, FLOOR_SHELF_ITEM_CRIMSON);
        SHELVES_JSON = new ArrayList<JsonObject>();
        for (String material : MATERIALS) {
            SHELVES_JSON.add(ShelfModCommon.createShelfRecipe(material));
            SHELVES_JSON.add(ShelfModCommon.createFloorShelfRecipe(material));
        }
    }

    static {
        MATERIALS = List.of("oak", "acacia", "birch", "dark_oak", "spruce", "jungle", "mangrove", "bamboo", "warped", "cherry", "crimson");
    }
}

