/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.client.animation.gltf;

import com.tacz.guns.api.client.animation.gltf.AccessorModel;
import com.tacz.guns.api.client.animation.gltf.NodeModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AnimationModel {
    private final List<Channel> channels = new ArrayList<Channel>();
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addChannel(Channel channel) {
        Objects.requireNonNull(channel, "The channel may not be null");
        this.channels.add(channel);
    }

    public List<Channel> getChannels() {
        return Collections.unmodifiableList(this.channels);
    }

    public record Channel(Sampler sampler, NodeModel nodeModel, String path) {
        public Channel(Sampler sampler, NodeModel nodeModel, String path) {
            this.sampler = Objects.requireNonNull(sampler, "The sampler may not be null");
            this.nodeModel = nodeModel;
            this.path = Objects.requireNonNull(path, "The path may not be null");
        }
    }

    public record Sampler(AccessorModel input, Interpolation interpolation, AccessorModel output) {
        public Sampler(AccessorModel input, Interpolation interpolation, AccessorModel output) {
            this.input = Objects.requireNonNull(input, "The input may not be null");
            this.interpolation = Objects.requireNonNull(interpolation, "The interpolation may not be null");
            this.output = Objects.requireNonNull(output, "The output may not be null");
        }
    }

    public static enum Interpolation {
        STEP,
        LINEAR,
        SPLINE;

    }
}

