/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.item.nbt;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.item.IAttachment;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public interface AttachmentItemDataAccessor
extends IAttachment {
    public static final String ATTACHMENT_ID_TAG = "AttachmentId";
    public static final String SKIN_ID_TAG = "Skin";
    public static final String ZOOM_NUMBER_TAG = "ZoomNumber";

    public static boolean isAttachmentLike(CompoundTag tag) {
        return tag.m_128425_(ATTACHMENT_ID_TAG, 8);
    }

    @Nonnull
    public static ResourceLocation getAttachmentIdFromTag(@Nullable CompoundTag nbt) {
        if (nbt == null) {
            return DefaultAssets.EMPTY_ATTACHMENT_ID;
        }
        if (AttachmentItemDataAccessor.isAttachmentLike(nbt)) {
            ResourceLocation attachmentId = ResourceLocation.m_135820_((String)nbt.m_128461_(ATTACHMENT_ID_TAG));
            return Objects.requireNonNullElse(attachmentId, DefaultAssets.EMPTY_ATTACHMENT_ID);
        }
        return DefaultAssets.EMPTY_ATTACHMENT_ID;
    }

    public static int getZoomNumberFromTag(@Nullable CompoundTag nbt) {
        if (nbt == null) {
            return 0;
        }
        if (nbt.m_128425_(ZOOM_NUMBER_TAG, 3)) {
            return nbt.m_128451_(ZOOM_NUMBER_TAG);
        }
        return 0;
    }

    public static void setZoomNumberToTag(CompoundTag nbt, int zoomNumber) {
        nbt.m_128405_(ZOOM_NUMBER_TAG, zoomNumber);
    }

    @Override
    @Nonnull
    default public ResourceLocation getAttachmentId(ItemStack attachmentStack) {
        CompoundTag nbt = attachmentStack.m_41784_();
        return AttachmentItemDataAccessor.getAttachmentIdFromTag(nbt);
    }

    @Override
    default public void setAttachmentId(ItemStack attachmentStack, @Nullable ResourceLocation attachmentId) {
        CompoundTag nbt = attachmentStack.m_41784_();
        if (attachmentId != null) {
            nbt.m_128359_(ATTACHMENT_ID_TAG, attachmentId.toString());
        }
    }

    @Override
    @Nullable
    default public ResourceLocation getSkinId(ItemStack attachmentStack) {
        CompoundTag nbt = attachmentStack.m_41784_();
        if (nbt.m_128425_(SKIN_ID_TAG, 8)) {
            return ResourceLocation.m_135820_((String)nbt.m_128461_(SKIN_ID_TAG));
        }
        return null;
    }

    @Override
    default public void setSkinId(ItemStack attachmentStack, @Nullable ResourceLocation skinId) {
        CompoundTag nbt = attachmentStack.m_41784_();
        if (skinId != null) {
            nbt.m_128359_(SKIN_ID_TAG, skinId.toString());
        } else {
            nbt.m_128473_(SKIN_ID_TAG);
        }
    }

    @Override
    default public int getZoomNumber(ItemStack attachmentStack) {
        CompoundTag nbt = attachmentStack.m_41784_();
        return AttachmentItemDataAccessor.getZoomNumberFromTag(nbt);
    }

    @Override
    default public void setZoomNumber(ItemStack attachmentStack, int zoomNumber) {
        CompoundTag nbt = attachmentStack.m_41784_();
        AttachmentItemDataAccessor.setZoomNumberToTag(nbt, zoomNumber);
    }
}

