/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.input;

import com.mojang.blaze3d.platform.InputConstants;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.config.util.InteractKeyConfigRead;
import com.tacz.guns.util.InputExtraCheck;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class InteractKey {
    public static final KeyMapping INTERACT_KEY = new KeyMapping("key.tacz.interact.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 79, "key.category.tacz");

    @SubscribeEvent
    public static void onInteractKeyPress(InputEvent.Key event) {
        if (InputExtraCheck.isInGame() && event.getAction() == 1 && INTERACT_KEY.m_90832_(event.getKey(), event.getScanCode())) {
            InteractKey.doInteractLogic();
        }
    }

    @SubscribeEvent
    public static void onInteractMousePress(InputEvent.MouseButton.Post event) {
        if (InputExtraCheck.isInGame() && event.getAction() == 1 && INTERACT_KEY.m_90830_(event.getButton())) {
            InteractKey.doInteractLogic();
        }
    }

    public static boolean onInteractControllerPress(boolean isPress) {
        if (InputExtraCheck.isInGame() && isPress) {
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            if (player == null || player.m_5833_()) {
                return false;
            }
            if (!IGun.mainhandHoldGun((LivingEntity)player)) {
                return false;
            }
            HitResult hitResult = mc.f_91077_;
            if (hitResult == null) {
                return false;
            }
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                InteractKey.interactBlock(blockHitResult, player, mc);
                return true;
            }
            if (hitResult instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)hitResult;
                InteractKey.interactEntity(entityHitResult, mc);
                return true;
            }
        }
        return false;
    }

    private static void doInteractLogic() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || player.m_5833_()) {
            return;
        }
        if (!IGun.mainhandHoldGun((LivingEntity)player)) {
            return;
        }
        HitResult hitResult = mc.f_91077_;
        if (hitResult == null) {
            return;
        }
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            InteractKey.interactBlock(blockHitResult, player, mc);
            return;
        }
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            InteractKey.interactEntity(entityHitResult, mc);
        }
    }

    private static void interactBlock(BlockHitResult blockHitResult, LocalPlayer player, Minecraft mc) {
        BlockPos blockPos = blockHitResult.m_82425_();
        BlockState block = player.m_9236_().m_8055_(blockPos);
        if (InteractKeyConfigRead.canInteractBlock(block)) {
            mc.m_91277_();
        }
    }

    private static void interactEntity(EntityHitResult entityHitResult, Minecraft mc) {
        Entity entity = entityHitResult.m_82443_();
        if (InteractKeyConfigRead.canInteractEntity(entity)) {
            mc.m_91277_();
        }
    }
}

