/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.model.BedrockGunModel;
import com.tacz.guns.client.model.SlotModel;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.client.resource.pojo.TransformScale;
import com.tacz.guns.util.RenderDistance;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector3f;

public class GunItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final SlotModel SLOT_GUN_MODEL = new SlotModel();

    public GunItemRenderer(BlockEntityRenderDispatcher pBlockEntityRenderDispatcher, EntityModelSet pEntityModelSet) {
        super(pBlockEntityRenderDispatcher, pEntityModelSet);
    }

    private static void applyPositioningNodeTransform(List<BedrockPart> nodePath, PoseStack poseStack, Vector3f scale) {
        if (nodePath == null) {
            return;
        }
        if (scale == null) {
            scale = new Vector3f(1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85837_(0.0, 1.5, 0.0);
        for (int i = nodePath.size() - 1; i >= 0; --i) {
            BedrockPart t = nodePath.get(i);
            poseStack.m_252781_(Axis.f_252495_.m_252961_(t.xRot));
            poseStack.m_252781_(Axis.f_252392_.m_252961_(t.yRot));
            poseStack.m_252781_(Axis.f_252393_.m_252961_(t.zRot));
            if (t.getParent() != null) {
                poseStack.m_252880_(-t.x * scale.x() / 16.0f, -t.y * scale.y() / 16.0f, -t.z * scale.z() / 16.0f);
                continue;
            }
            poseStack.m_252880_(-t.x * scale.x() / 16.0f, (1.5f - t.y / 16.0f) * scale.y(), -t.z * scale.z() / 16.0f);
        }
        poseStack.m_85837_(0.0, -1.5, 0.0);
    }

    public void m_108829_(@Nonnull ItemStack stack, @Nonnull ItemDisplayContext transformType, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        Item item = stack.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        poseStack.m_85836_();
        TimelessAPI.getGunDisplay(stack).ifPresentOrElse(gunIndex -> {
            ResourceLocation gunTexture;
            BedrockGunModel gunModel;
            if (transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                return;
            }
            if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
                return;
            }
            if (transformType == ItemDisplayContext.GUI) {
                poseStack.m_85837_(0.5, 1.5, 0.5);
                poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
                VertexConsumer buffer = pBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)gunIndex.getSlotTexture()));
                SLOT_GUN_MODEL.m_7695_(poseStack, buffer, pPackedLight, pPackedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                return;
            }
            Pair<BedrockGunModel, ResourceLocation> lodModel = gunIndex.getLodModel();
            if (lodModel == null || RenderDistance.inRenderHighPolyModelDistance(poseStack)) {
                gunModel = gunIndex.getGunModel();
                gunTexture = gunIndex.getModelTexture();
            } else {
                gunModel = (BedrockGunModel)lodModel.getLeft();
                gunTexture = (ResourceLocation)lodModel.getRight();
            }
            poseStack.m_85837_(0.5, 2.0, 0.5);
            poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
            this.applyPositioningTransform(transformType, gunIndex.getTransform().getScale(), gunModel, poseStack);
            this.applyScaleTransform(transformType, gunIndex.getTransform().getScale(), poseStack);
            RenderType renderType = RenderType.m_110452_((ResourceLocation)gunTexture);
            gunModel.render(poseStack, stack, transformType, renderType, pPackedLight, pPackedOverlay);
        }, () -> {
            poseStack.m_85837_(0.5, 1.5, 0.5);
            poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
            VertexConsumer buffer = pBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)MissingTextureAtlasSprite.m_118071_()));
            SLOT_GUN_MODEL.m_7695_(poseStack, buffer, pPackedLight, pPackedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        });
        poseStack.m_85849_();
    }

    private void applyPositioningTransform(ItemDisplayContext transformType, TransformScale scale, BedrockGunModel model, PoseStack poseStack) {
        switch (transformType) {
            case FIXED: {
                GunItemRenderer.applyPositioningNodeTransform(model.getFixedOriginPath(), poseStack, scale.getFixed());
                break;
            }
            case GROUND: {
                GunItemRenderer.applyPositioningNodeTransform(model.getGroundOriginPath(), poseStack, scale.getGround());
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: 
            case THIRD_PERSON_LEFT_HAND: {
                GunItemRenderer.applyPositioningNodeTransform(model.getThirdPersonHandOriginPath(), poseStack, scale.getThirdPerson());
            }
        }
    }

    private void applyScaleTransform(ItemDisplayContext transformType, TransformScale scale, PoseStack poseStack) {
        if (scale == null) {
            return;
        }
        Vector3f vector3f = null;
        switch (transformType) {
            case FIXED: {
                vector3f = scale.getFixed();
                break;
            }
            case GROUND: {
                vector3f = scale.getGround();
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: 
            case THIRD_PERSON_LEFT_HAND: {
                vector3f = scale.getThirdPerson();
            }
        }
        if (vector3f != null) {
            poseStack.m_85837_(0.0, 1.5, 0.0);
            poseStack.m_85841_(vector3f.x(), vector3f.y(), vector3f.z());
            poseStack.m_85837_(0.0, -1.5, 0.0);
        }
    }
}

