/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.compat.jei;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.builder.BlockItemBuilder;
import com.tacz.guns.api.item.gun.GunItemManager;
import com.tacz.guns.compat.jei.GunModSubtype;
import com.tacz.guns.compat.jei.category.AttachmentQueryCategory;
import com.tacz.guns.compat.jei.category.GunSmithTableCategory;
import com.tacz.guns.compat.jei.entry.AttachmentQueryEntry;
import com.tacz.guns.crafting.GunSmithTableRecipe;
import com.tacz.guns.init.ModItems;
import com.tacz.guns.init.ModRecipe;
import com.tacz.guns.resource.index.CommonBlockIndex;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class GunModPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("tacz", "jei");
    private Map<ResourceLocation, RecipeType<GunSmithTableRecipe>> recipeTypeMap = new HashMap<ResourceLocation, RecipeType<GunSmithTableRecipe>>();

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.recipeTypeMap.clear();
        Set<Map.Entry<ResourceLocation, CommonBlockIndex>> map = TimelessAPI.getAllCommonBlockIndex();
        for (Map.Entry<ResourceLocation, CommonBlockIndex> entry : map) {
            BlockItem item = entry.getValue().getBlock();
            ItemStack icon = BlockItemBuilder.create((ItemLike)item).setId(entry.getKey()).build();
            RecipeType type = RecipeType.create((String)"tacz", (String)("gun_smith_table/" + entry.getKey().toString().replace(':', '_')), GunSmithTableRecipe.class);
            registration.addRecipeCategories(new IRecipeCategory[]{new GunSmithTableCategory(registration.getJeiHelpers().getGuiHelper(), icon, (RecipeType<GunSmithTableRecipe>)type, item.m_7626_(icon))});
            this.recipeTypeMap.put(entry.getKey(), (RecipeType<GunSmithTableRecipe>)type);
        }
        registration.addRecipeCategories(new IRecipeCategory[]{new AttachmentQueryCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        List recipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipe.GUN_SMITH_TABLE_CRAFTING.get());
        for (Map.Entry<ResourceLocation, RecipeType<GunSmithTableRecipe>> entry : this.recipeTypeMap.entrySet()) {
            TimelessAPI.getCommonBlockIndex(entry.getKey()).ifPresent(blockIndex -> {
                List<GunSmithTableRecipe> recipeList = blockIndex.getFilter().filter(recipes, GunSmithTableRecipe::m_6423_);
                registration.addRecipes((RecipeType)entry.getValue(), recipeList);
            });
        }
        registration.addRecipes(AttachmentQueryCategory.ATTACHMENT_QUERY, AttachmentQueryEntry.getAllAttachmentQueryEntries());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        for (Map.Entry<ResourceLocation, RecipeType<GunSmithTableRecipe>> entry : this.recipeTypeMap.entrySet()) {
            TimelessAPI.getCommonBlockIndex(entry.getKey()).ifPresent(blockIndex -> {
                ItemStack stack = BlockItemBuilder.create((ItemLike)blockIndex.getBlock()).setId((ResourceLocation)entry.getKey()).build();
                registration.addRecipeCatalyst(stack, new RecipeType[]{(RecipeType)entry.getValue()});
            });
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModItems.AMMO.get()), GunModSubtype.getAmmoSubtype());
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModItems.ATTACHMENT.get()), GunModSubtype.getAttachmentSubtype());
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModItems.AMMO_BOX.get()), GunModSubtype.getAmmoBoxSubtype());
        GunItemManager.getAllGunItems().forEach(item -> registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)item.get()), GunModSubtype.getGunSubtype()));
    }

    public ResourceLocation getPluginUid() {
        return UID;
    }
}

