/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.modifier.custom;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.api.modifier.CacheValue;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.attachment.Modifier;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunFireModeAdjustData;
import com.tacz.guns.resource.pojo.data.gun.InaccuracyType;
import com.tacz.guns.resource_legacy.CommonGunPackLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AimInaccuracyModifier
implements IAttachmentModifier<Map<InaccuracyType, Modifier>, Map<InaccuracyType, Float>> {
    public static final String ID = "aim_inaccuracy";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public JsonProperty<Map<InaccuracyType, Modifier>> readJson(String json) {
        Data data = (Data)CommonGunPackLoader.GSON.fromJson(json, Data.class);
        Modifier inaccuracy = data.getAimInaccuracy();
        HashMap jsonProperties = Maps.newHashMap();
        for (InaccuracyType type : InaccuracyType.values()) {
            if (!type.isAim()) continue;
            jsonProperties.put(type, inaccuracy);
        }
        return new AimInaccuracyJsonProperty(jsonProperties);
    }

    @Override
    public CacheValue<Map<InaccuracyType, Float>> initCache(ItemStack gunItem, GunData gunData) {
        HashMap tmp = Maps.newHashMap();
        IGun iGun = Objects.requireNonNull(IGun.getIGunOrNull(gunItem));
        FireMode fireMode = iGun.getFireMode(gunItem);
        gunData.getInaccuracy().forEach((type, value) -> {
            float inaccuracyAddend = 0.0f;
            GunFireModeAdjustData fireModeAdjustData = gunData.getFireModeAdjustData(fireMode);
            if (fireModeAdjustData != null) {
                inaccuracyAddend = type == InaccuracyType.AIM ? fireModeAdjustData.getAimInaccuracy() : fireModeAdjustData.getOtherInaccuracy();
            }
            float inaccuracy = gunData.getInaccuracy((InaccuracyType)((Object)type), inaccuracyAddend);
            tmp.put(type, Float.valueOf(inaccuracy));
        });
        return new CacheValue<Map<InaccuracyType, Float>>(tmp);
    }

    @Override
    public void eval(List<Map<InaccuracyType, Modifier>> modifiedValues, CacheValue<Map<InaccuracyType, Float>> cache) {
        HashMap result = Maps.newHashMap();
        HashMap tmpModified = Maps.newHashMap();
        for (InaccuracyType type2 : InaccuracyType.values()) {
            if (!type2.isAim()) continue;
            for (Map<InaccuracyType, Modifier> value2 : modifiedValues) {
                tmpModified.computeIfAbsent(type2, t -> Lists.newArrayList()).add(value2.get((Object)type2));
            }
        }
        cache.getValue().forEach((type, value) -> {
            if (!type.isAim()) {
                result.put(type, value);
                return;
            }
            double eval = AttachmentPropertyManager.eval((List)tmpModified.get(type), (double)((Float)((Map)cache.getValue()).get(type)).floatValue());
            result.put(type, Float.valueOf((float)eval));
        });
        cache.setValue(result);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IAttachmentModifier.DiagramsData> getPropertyDiagramsData(ItemStack gunItem, GunData gunData, AttachmentCacheProperty cacheProperty) {
        IGun iGun = Objects.requireNonNull(IGun.getIGunOrNull(gunItem));
        FireMode fireMode = iGun.getFireMode(gunItem);
        GunFireModeAdjustData fireModeAdjustData = gunData.getFireModeAdjustData(fireMode);
        float aimInaccuracy = gunData.getInaccuracy(InaccuracyType.AIM);
        if (fireModeAdjustData != null) {
            aimInaccuracy += fireModeAdjustData.getAimInaccuracy();
        }
        aimInaccuracy = (1.0f - aimInaccuracy) * 100.0f;
        float inaccuracyModifier = ((Float)((Map)cacheProperty.getCache(ID)).get((Object)InaccuracyType.AIM)).floatValue();
        inaccuracyModifier = (1.0f - inaccuracyModifier) * 100.0f - aimInaccuracy;
        double aimInaccuracyPercent = Math.min((double)aimInaccuracy / 100.0, 1.0);
        double inaccuracyModifierPercent = Math.min((double)inaccuracyModifier / 100.0, 1.0);
        String titleKey = "gui.tacz.gun_refit.property_diagrams.aim_inaccuracy";
        String positivelyString = String.format("%.1f%% \u00a7a(+%.1f%%)", Float.valueOf(aimInaccuracy), Float.valueOf(inaccuracyModifier));
        String negativelyString = String.format("%.1f%% \u00a7c(%.1f%%)", Float.valueOf(aimInaccuracy), Float.valueOf(inaccuracyModifier));
        String defaultString = String.format("%.1f%%", Float.valueOf(aimInaccuracy));
        boolean positivelyBetter = true;
        IAttachmentModifier.DiagramsData diagramsData = new IAttachmentModifier.DiagramsData(aimInaccuracyPercent, inaccuracyModifierPercent, Float.valueOf(inaccuracyModifier), titleKey, positivelyString, negativelyString, defaultString, positivelyBetter);
        return Collections.singletonList(diagramsData);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getDiagramsDataSize() {
        return 1;
    }

    public static class Data {
        @Nullable
        @SerializedName(value="aim_inaccuracy")
        private Modifier aimInaccuracy;

        @Nullable
        public Modifier getAimInaccuracy() {
            return this.aimInaccuracy;
        }
    }

    public static class AimInaccuracyJsonProperty
    extends JsonProperty<Map<InaccuracyType, Modifier>> {
        public AimInaccuracyJsonProperty(Map<InaccuracyType, Modifier> value) {
            super(value);
        }

        @Override
        public void initComponents() {
            Map value = (Map)this.getValue();
            float inaccuracyAddend = 0.0f;
            if (value != null && value.containsKey((Object)InaccuracyType.AIM)) {
                double eval = AttachmentPropertyManager.eval((Modifier)value.get((Object)InaccuracyType.AIM), (double)0.15f);
                inaccuracyAddend = (float)(eval - (double)0.15f);
            }
            if (inaccuracyAddend > 0.0f) {
                this.components.add(Component.m_237115_((String)"tooltip.tacz.attachment.aim_inaccuracy.decrease").m_130940_(ChatFormatting.RED));
            } else if (inaccuracyAddend < 0.0f) {
                this.components.add(Component.m_237115_((String)"tooltip.tacz.attachment.aim_inaccuracy.increase").m_130940_(ChatFormatting.GREEN));
            }
        }
    }
}

