/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.modifier.custom;

import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.modifier.CacheValue;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.attachment.Modifier;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource_legacy.CommonGunPackLoader;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PierceModifier
implements IAttachmentModifier<Modifier, Integer> {
    public static final String ID = "pierce";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public JsonProperty<Modifier> readJson(String json) {
        Data data = (Data)CommonGunPackLoader.GSON.fromJson(json, Data.class);
        return new DamageJsonProperty(data.getPierce());
    }

    @Override
    public CacheValue<Integer> initCache(ItemStack gunItem, GunData gunData) {
        int pierce = gunData.getBulletData().getPierce();
        return new CacheValue<Integer>(pierce);
    }

    @Override
    public void eval(List<Modifier> modifiers, CacheValue<Integer> cache) {
        double eval = AttachmentPropertyManager.eval(modifiers, (double)cache.getValue().intValue());
        cache.setValue((int)Math.round(eval));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IAttachmentModifier.DiagramsData> getPropertyDiagramsData(ItemStack gunItem, GunData gunData, AttachmentCacheProperty cacheProperty) {
        int pierce = gunData.getBulletData().getPierce();
        int pierceModifier = (Integer)cacheProperty.getCache(ID) - pierce;
        double piercePercent = Math.min((double)pierce / 10.0, 1.0);
        double pierceModifierPercent = Math.min((double)pierceModifier / 10.0, 1.0);
        String titleKey = "gui.tacz.gun_refit.property_diagrams.pierce";
        String positivelyString = String.format("%d \u00a7a(+%d)", pierce, pierceModifier);
        String negativelyString = String.format("%d \u00a7c(%d)", pierce, pierceModifier);
        String defaultString = String.format("%d", pierce);
        boolean positivelyBetter = true;
        IAttachmentModifier.DiagramsData diagramsData = new IAttachmentModifier.DiagramsData(piercePercent, pierceModifierPercent, pierceModifier, titleKey, positivelyString, negativelyString, defaultString, positivelyBetter);
        return Collections.singletonList(diagramsData);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getDiagramsDataSize() {
        return 1;
    }

    public static class Data {
        @SerializedName(value="pierce")
        @Nullable
        private Modifier pierce = null;

        @Nullable
        public Modifier getPierce() {
            return this.pierce;
        }
    }

    public static class DamageJsonProperty
    extends JsonProperty<Modifier> {
        public DamageJsonProperty(Modifier value) {
            super(value);
        }

        @Override
        public void initComponents() {
            Modifier pierce = (Modifier)this.getValue();
            if (pierce != null) {
                long eval = Math.round(AttachmentPropertyManager.eval(pierce, 5.0));
                if ((eval = Math.max(eval, 1L)) > 5L) {
                    this.components.add(Component.m_237115_((String)"tooltip.tacz.attachment.pierce.increase").m_130940_(ChatFormatting.GREEN));
                } else if (eval < 5L) {
                    this.components.add(Component.m_237115_((String)"tooltip.tacz.attachment.pierce.decrease").m_130940_(ChatFormatting.RED));
                }
            }
        }
    }
}

