/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.serialize;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.tacz.guns.crafting.result.GunSmithTableResult;
import com.tacz.guns.crafting.result.RawGunTableResult;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.pojo.data.recipe.GunResult;
import java.lang.reflect.Type;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.CraftingHelper;

public class GunSmithTableResultSerializer
implements JsonDeserializer<GunSmithTableResult> {
    public GunSmithTableResult deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            GunSmithTableResult result;
            JsonObject jsonObject = json.getAsJsonObject();
            String typeName = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"type");
            int count = 1;
            CompoundTag extraTag = null;
            if (jsonObject.has("count")) {
                count = Math.max(GsonHelper.m_13927_((JsonObject)jsonObject, (String)"count"), 1);
            }
            if (jsonObject.has("nbt")) {
                extraTag = CraftingHelper.getNBT((JsonElement)jsonObject.get("nbt"));
            }
            switch (typeName) {
                case "gun": 
                case "ammo": 
                case "attachment": {
                    GunResult gunResult;
                    RawGunTableResult raw = new RawGunTableResult(typeName, this.getId(jsonObject), count);
                    if (extraTag != null) {
                        raw.setNbt(extraTag);
                    }
                    if (typeName.equals("gun") && (gunResult = (GunResult)CommonAssetsManager.GSON.fromJson((JsonElement)jsonObject, GunResult.class)) != null) {
                        raw.setExtraData(gunResult);
                    }
                    result = new GunSmithTableResult(raw);
                    break;
                }
                case "custom": {
                    JsonObject resultObject = GsonHelper.m_13930_((JsonObject)jsonObject, (String)"item");
                    String group = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
                    ItemStack itemStack = CraftingHelper.getItemStack((JsonObject)resultObject, (boolean)true);
                    result = new GunSmithTableResult(itemStack, group);
                    if (extraTag == null) break;
                    CompoundTag itemTag = result.getResult().m_41784_();
                    for (String key : extraTag.m_128431_()) {
                        Tag tag = extraTag.m_128423_(key);
                        if (tag == null) continue;
                        itemTag.m_128365_(key, tag);
                    }
                    break;
                }
                default: {
                    return new GunSmithTableResult(ItemStack.f_41583_, "");
                }
            }
            return result;
        }
        return new GunSmithTableResult(ItemStack.f_41583_, "");
    }

    private ResourceLocation getId(JsonObject jsonObject) {
        return new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"id"));
    }
}

