/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource_legacy.network;

import com.google.common.collect.Maps;
import com.tacz.guns.client.resource_legacy.ClientGunPackLoader;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.ServerMessageSyncGunPack;
import com.tacz.guns.resource.network.DataType;
import com.tacz.guns.resource_legacy.loader.CommonDataLoaders;
import com.tacz.guns.resource_legacy.loader.asset.AllowAttachmentTagsLoader;
import com.tacz.guns.resource_legacy.loader.asset.AttachmentDataLoader;
import com.tacz.guns.resource_legacy.loader.asset.AttachmentTagsLoader;
import com.tacz.guns.resource_legacy.loader.asset.GunDataLoader;
import com.tacz.guns.resource_legacy.loader.asset.RecipeLoader;
import com.tacz.guns.resource_legacy.loader.index.CommonAmmoIndexLoader;
import com.tacz.guns.resource_legacy.loader.index.CommonAttachmentIndexLoader;
import com.tacz.guns.resource_legacy.loader.index.CommonGunIndexLoader;
import com.tacz.guns.resource_legacy.loader.index.CommonIndexLoaders;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@Deprecated
public class CommonGunPackNetwork {
    private static final Pattern SHA1 = Pattern.compile("^[a-fA-F0-9]{40}$");
    private static final EnumMap<DataType, Map<ResourceLocation, String>> NETWORK_CACHE = new EnumMap(DataType.class);

    public static void clear() {
        NETWORK_CACHE.clear();
    }

    public static void addData(DataType type, ResourceLocation id, String json) {
        NETWORK_CACHE.computeIfAbsent(type, k -> Maps.newHashMap()).put(id, json);
    }

    public static void syncClient(MinecraftServer server) {
        server.m_6846_().m_11314_().forEach(player -> NetworkHandler.sendToClientPlayer(new ServerMessageSyncGunPack(NETWORK_CACHE), (Player)player));
    }

    public static void syncClientExceptSelf(MinecraftServer server, @Nullable Player self) {
        server.m_6846_().m_11314_().forEach(player -> {
            if (!player.equals((Object)self)) {
                ServerMessageSyncGunPack message = new ServerMessageSyncGunPack(NETWORK_CACHE);
                NetworkHandler.sendToClientPlayer(message, (Player)player);
            }
        });
    }

    public static void syncClient(ServerPlayer player) {
        NetworkHandler.sendToClientPlayer(new ServerMessageSyncGunPack(NETWORK_CACHE), (Player)player);
    }

    public static void toNetwork(EnumMap<DataType, Map<ResourceLocation, String>> cache, FriendlyByteBuf buf) {
        buf.m_130130_(cache.size());
        cache.forEach((type, caches) -> {
            buf.m_130068_((Enum)type);
            buf.m_130130_(caches.size());
            caches.forEach((id, data) -> {
                buf.m_130085_(id);
                buf.m_130070_(data);
            });
        });
    }

    public static EnumMap<DataType, Map<ResourceLocation, String>> fromNetworkCache(FriendlyByteBuf buf) {
        EnumMap cache = Maps.newEnumMap(DataType.class);
        int typeSize = buf.m_130242_();
        for (int i = 0; i < typeSize; ++i) {
            DataType type = (DataType)buf.m_130066_(DataType.class);
            int size = buf.m_130242_();
            for (int j = 0; j < size; ++j) {
                ResourceLocation id = buf.m_130281_();
                String json = buf.m_130277_();
                cache.computeIfAbsent(type, k -> Maps.newHashMap()).put(id, json);
            }
        }
        return cache;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void loadFromCache(EnumMap<DataType, Map<ResourceLocation, String>> allCache) {
        allCache.forEach((type, cache) -> cache.forEach((id, json) -> {
            switch (type) {
                case GUN_DATA: {
                    GunDataLoader.loadFromJsonString(id, json);
                    break;
                }
                case ATTACHMENT_DATA: {
                    AttachmentDataLoader.loadFromJsonString(id, json);
                    break;
                }
                case AMMO_INDEX: {
                    CommonAmmoIndexLoader.loadAmmoFromJsonString(id, json);
                    break;
                }
                case GUN_INDEX: {
                    CommonGunIndexLoader.loadGunFromJsonString(id, json);
                    break;
                }
                case BLOCK_INDEX: {
                    CommonIndexLoaders.BLOCK.resolveJson((ResourceLocation)id, (String)json);
                    break;
                }
                case ATTACHMENT_INDEX: {
                    CommonAttachmentIndexLoader.loadAttachmentFromJsonString(id, json);
                    break;
                }
                case RECIPES: {
                    RecipeLoader.loadFromJsonString(id, json);
                    break;
                }
                case RECIPE_FILTER: {
                    CommonDataLoaders.RECIPE_FILTER.resolveJson((ResourceLocation)id, (String)json);
                    break;
                }
                case ATTACHMENT_TAGS: {
                    AttachmentTagsLoader.loadFromJsonString(id, json);
                    break;
                }
                case ALLOW_ATTACHMENT_TAGS: {
                    AllowAttachmentTagsLoader.loadFromJsonString(id, json);
                    break;
                }
                case BLOCK_DATA: {
                    CommonDataLoaders.BLOCKS.resolveJson((ResourceLocation)id, (String)json);
                }
            }
        }));
        ClientGunPackLoader.reloadIndex();
    }
}

