/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals;

import com.tom.peripherals.block.GPUBlock;
import com.tom.peripherals.block.KeyboardBlock;
import com.tom.peripherals.block.KeyboardDongleBlock;
import com.tom.peripherals.block.MonitorBlock;
import com.tom.peripherals.block.RedstonePortBlock;
import com.tom.peripherals.block.WatchDogTimerBlock;
import com.tom.peripherals.block.entity.GPUBlockEntity;
import com.tom.peripherals.block.entity.KeyboardBlockEntity;
import com.tom.peripherals.block.entity.MonitorBlockEntity;
import com.tom.peripherals.block.entity.RedstonePortBlockEntity;
import com.tom.peripherals.block.entity.WatchDogTimerBlockEntity;
import com.tom.peripherals.item.LaserPointerItem;
import com.tom.peripherals.item.PortableKeyboardItem;
import com.tom.peripherals.menu.KeyboardMenu;
import com.tom.peripherals.platform.GameObject;
import com.tom.peripherals.platform.Platform;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class Content {
    public static final GameObject<GPUBlock> gpu = Content.blockWithItem("gpu", GPUBlock::new);
    public static final GameObject<MonitorBlock> monitor = Content.blockWithItem("monitor", MonitorBlock::new);
    public static final GameObject<WatchDogTimerBlock> wdt = Content.blockWithItem("wdt", WatchDogTimerBlock::new);
    public static final GameObject<RedstonePortBlock> redstonePort = Content.blockWithItem("redstone_port", RedstonePortBlock::new);
    public static final GameObject<KeyboardBlock> keyboard = Content.blockWithItem("keyboard", KeyboardBlock::new);
    public static final GameObject<KeyboardDongleBlock> keyboard_dongle = Content.blockWithItem("keyboard_dongle", KeyboardDongleBlock::new);
    public static final GameObject<Item> gpuChip = Content.item("gpu_chip", () -> new Item(new Item.Properties()));
    public static final GameObject<Item> gpuChipRaw = Content.item("gpu_chip_raw", () -> new Item(new Item.Properties()));
    public static final GameObject<LaserPointerItem> laserPointer = Content.item("laser_pointer", () -> new LaserPointerItem());
    public static final GameObject<PortableKeyboardItem> portableKeyboard = Content.item("portable_keyboard", () -> new PortableKeyboardItem());
    public static final GameObject.GameObjectBlockEntity<GPUBlockEntity> gpuBE = Content.blockEntity("gpu", GPUBlockEntity::new, gpu);
    public static final GameObject.GameObjectBlockEntity<MonitorBlockEntity> monitorBE = Content.blockEntity("monitor", MonitorBlockEntity::new, monitor);
    public static final GameObject.GameObjectBlockEntity<WatchDogTimerBlockEntity> wdtBE = Content.blockEntity("wdt", WatchDogTimerBlockEntity::new, wdt);
    public static final GameObject.GameObjectBlockEntity<RedstonePortBlockEntity> redstonePortBE = Content.blockEntity("redstone_port", RedstonePortBlockEntity::new, redstonePort);
    public static final GameObject.GameObjectBlockEntity<KeyboardBlockEntity> keyboardBE = Content.blockEntity("keyboard", KeyboardBlockEntity::new, keyboard, keyboard_dongle);
    public static final GameObject<MenuType<KeyboardMenu>> keyboardMenu = Content.menu("keyboard", KeyboardMenu::new);

    private static <B extends Block> GameObject<B> blockWithItem(String name, Supplier<B> create) {
        return Content.blockWithItem(name, create, b -> new BlockItem(b, new Item.Properties()));
    }

    private static <B extends Block, I extends Item> GameObject<B> blockWithItem(String name, Supplier<B> create, Function<Block, I> createItem) {
        GameObject re = Platform.BLOCKS.register(name, create);
        Content.item(name, () -> (Item)createItem.apply((Block)re.get()));
        return re;
    }

    private static <I extends Item> GameObject<I> item(String name, Supplier<I> fact) {
        return Platform.ITEMS.register(name, () -> Platform.addItemToTab((Item)fact.get()));
    }

    @SafeVarargs
    private static <BE extends BlockEntity> GameObject.GameObjectBlockEntity<BE> blockEntity(String name, GameObject.GameRegistryBE.BlockEntityFactory<? extends BE> create, GameObject<? extends Block> ... blocks) {
        return Platform.BLOCK_ENTITY.registerBE(name, create, blocks);
    }

    private static <M extends AbstractContainerMenu> GameObject<MenuType<M>> menu(String name, MenuType.MenuSupplier<M> create) {
        return Platform.MENU_TYPE.register(name, () -> new MenuType(create, FeatureFlags.f_244377_));
    }

    public static void init() {
    }
}

