/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.block.entity;

import com.tom.peripherals.Content;
import com.tom.peripherals.api.IComputer;
import com.tom.peripherals.api.ITMPeripheral;
import com.tom.peripherals.api.LuaException;
import com.tom.peripherals.menu.KeyboardMenu;
import com.tom.peripherals.platform.AbstractPeripheralBlockEntity;
import com.tom.peripherals.util.ParamCheck;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class KeyboardBlockEntity
extends AbstractPeripheralBlockEntity
implements MenuProvider {
    private Peripheral per;

    public KeyboardBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    @Override
    public Peripheral getPeripheral() {
        if (this.per == null) {
            this.per = new Peripheral();
        }
        return this.per;
    }

    public AbstractContainerMenu m_7208_(int p_39954_, Inventory p_39955_, Player p_39956_) {
        return new KeyboardMenu(p_39954_, p_39955_, this);
    }

    public Component m_5446_() {
        return Component.m_237119_();
    }

    public void queueEvent(String event, Object[] args) {
        this.getPeripheral().queueEvent(event, args);
    }

    public void onKeyboardOpen(int id) {
        if (this.m_58900_().m_60713_((Block)Content.keyboard_dongle.get())) {
            this.queueEvent("portable_connect", new Object[]{id});
        }
    }

    public void onKeyboardClosed(int id) {
        if (this.m_58900_().m_60713_((Block)Content.keyboard_dongle.get())) {
            this.queueEvent("portable_disconnect", new Object[]{id});
        }
    }

    public boolean menuStillValid(Player player) {
        if (this.m_58900_().m_60713_((Block)Content.keyboard_dongle.get())) {
            return this.f_58858_.m_123331_((Vec3i)player.m_20183_()) < 4096.0;
        }
        return this.f_58858_.m_123331_((Vec3i)player.m_20183_()) < 256.0;
    }

    private class Peripheral
    implements ITMPeripheral {
        private static final String[] METHODS = new String[]{"setFireNativeEvents"};
        private Map<IComputer, CompSettings> computers = new ConcurrentHashMap<IComputer, CompSettings>();

        private Peripheral() {
        }

        @Override
        public String getType() {
            return "tm_keyboard";
        }

        @Override
        public String[] getMethodNames() {
            return METHODS;
        }

        @Override
        public Object[] call(IComputer computer, String method, Object[] args) throws LuaException {
            if (method.equals("setFireNativeEvents")) {
                boolean v;
                this.computers.computeIfAbsent((IComputer)computer, (Function<IComputer, CompSettings>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$call$0(com.tom.peripherals.api.IComputer ), (Lcom/tom/peripherals/api/IComputer;)Lcom/tom/peripherals/block/entity/KeyboardBlockEntity$CompSettings;)()).fireNativeEvents = v = ParamCheck.getBoolean(args, 0);
            }
            return null;
        }

        @Override
        public void attach(IComputer computer) {
            this.computers.put(computer, new CompSettings());
        }

        @Override
        public void detach(IComputer computer) {
            this.computers.remove(computer);
        }

        public void queueEvent(String event, Object[] args) {
            Object[] a = new Object[args.length + 1];
            for (int i = 0; i < args.length; ++i) {
                a[i + 1] = args[i];
            }
            for (Map.Entry<IComputer, CompSettings> c : this.computers.entrySet()) {
                if (c.getValue().fireNativeEvents) {
                    c.getKey().queueEvent(event, args);
                    continue;
                }
                a[0] = c.getKey().getAttachmentName();
                c.getKey().queueEvent("tm_keyboard_" + event, a);
            }
        }

        private static /* synthetic */ CompSettings lambda$call$0(IComputer __) {
            return new CompSettings();
        }
    }

    private static class CompSettings {
        private boolean fireNativeEvents;

        private CompSettings() {
        }
    }
}

