/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.block.entity;

import com.tom.peripherals.block.entity.GPUBlockEntity;
import com.tom.peripherals.math.Vec2i;
import com.tom.peripherals.screen.TextureCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class MonitorBlockEntity
extends BlockEntity {
    private BlockPos gpuPos;
    public TextureCache clientCache;
    public int[] screen = new int[0];
    public int width;

    public MonitorBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
    }

    public BlockPos getOffset(int x, int y, Direction d) {
        int xCoord = this.f_58858_.m_123341_();
        int yCoord = this.f_58858_.m_123342_();
        int zCoord = this.f_58858_.m_123343_();
        switch (d) {
            case DOWN: {
                return new BlockPos(xCoord + x, yCoord, zCoord + y);
            }
            case UP: {
                return new BlockPos(xCoord + x, yCoord, zCoord - y);
            }
            case NORTH: {
                return new BlockPos(xCoord - x, yCoord + y, zCoord);
            }
            case SOUTH: {
                return new BlockPos(xCoord + x, yCoord + y, zCoord);
            }
            case WEST: {
                return new BlockPos(xCoord, yCoord + y, zCoord + x);
            }
            case EAST: {
                return new BlockPos(xCoord, yCoord + y, zCoord - x);
            }
        }
        return new BlockPos(xCoord, yCoord, zCoord);
    }

    public MonitorBlockEntity connect(BlockPos gpuPos) {
        this.gpuPos = gpuPos;
        return this;
    }

    public void sync() {
        if (this.m_58904_() != null) {
            BlockState state = this.m_58904_().m_8055_(this.m_58899_());
            this.m_58904_().m_7260_(this.m_58899_(), state, state, 3);
        }
    }

    public void onBlockActivated(Direction side, double x, double y, double z, boolean sneak) {
        BlockEntity tile;
        if (this.getDirection() == side && this.gpuPos != null && (tile = this.f_58857_.m_7702_(this.gpuPos)) != null && tile instanceof GPUBlockEntity) {
            GPUBlockEntity gpu = (GPUBlockEntity)tile;
            Vec2i c = this.getMonitorPixel(side, x, y, z);
            gpu.monitorClick(this, c.x, c.y, sneak);
        }
    }

    public Vec2i getMonitorPixel(Direction side, double x, double y, double z) {
        int yP;
        int xP;
        if (side.m_122434_() != Direction.Axis.Y) {
            double yPos = 1.0 - y;
            double xPos = (double)Math.abs(side.m_122431_()) * x + (double)Math.abs(side.m_122429_()) * z;
            if (side.m_122421_() == Direction.AxisDirection.NEGATIVE != (side.m_122434_() == Direction.Axis.X)) {
                xPos = 1.0 - xPos;
            }
            xP = Mth.m_14107_((double)(xPos * (double)this.width));
            yP = Mth.m_14107_((double)(yPos * (double)this.width));
        } else {
            double yPos = side == Direction.DOWN ? 1.0 - z : z;
            xP = Mth.m_14107_((double)(x * (double)this.width));
            yP = Mth.m_14107_((double)(yPos * (double)this.width));
        }
        return new Vec2i(xP, yP);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128385_("s", this.screen);
        tag.m_128376_("w", (short)this.width);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        if (compoundTag.m_128441_("s")) {
            this.screen = compoundTag.m_128465_("s");
            this.width = compoundTag.m_128448_("w");
            if (this.clientCache != null) {
                this.clientCache.invalidate();
            }
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.clientCache != null) {
            this.clientCache.cleanup();
        }
        this.clientCache = null;
    }

    public void event(String ev, int x, int y, Integer param) {
        if (this.gpuPos == null) {
            return;
        }
        BlockEntity tile = this.f_58857_.m_7702_(this.gpuPos);
        if (tile != null && tile instanceof GPUBlockEntity) {
            GPUBlockEntity gpu = (GPUBlockEntity)tile;
            gpu.monitorEvent(this, ev, x, y, param);
        }
    }
}

