/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.block.entity;

import com.tom.peripherals.api.LuaException;
import com.tom.peripherals.api.LuaMethod;
import com.tom.peripherals.api.ObjectWrapper;
import com.tom.peripherals.api.TMLuaObject;
import com.tom.peripherals.cc.ComputerControl;
import com.tom.peripherals.platform.AbstractPeripheralBlockEntity;
import com.tom.peripherals.platform.Platform;
import com.tom.peripherals.util.ParamCheck;
import com.tom.peripherals.util.TickerUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class WatchDogTimerBlockEntity
extends AbstractPeripheralBlockEntity
implements TickerUtil.TickableServer {
    private ObjectWrapper peripheral;
    private boolean enabled;
    private int timeLimit;
    private int timer;

    public WatchDogTimerBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    @Override
    public void updateServer() {
        if (!this.enabled) {
            return;
        }
        if (this.timer > this.timeLimit) {
            this.enabled = false;
            Direction facting = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
            BlockPos onPos = this.m_58899_().m_121945_(facting);
            ComputerControl.restartComputerAt(this.f_58857_, onPos);
        } else {
            ++this.timer;
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.enabled = tag.m_128471_("enabled");
        this.timeLimit = tag.m_128451_("timeLimit");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("enabled", this.enabled);
        tag.m_128405_("timeLimit", this.timeLimit);
    }

    @Override
    public ObjectWrapper getPeripheral() {
        if (this.peripheral == null) {
            this.peripheral = new ObjectWrapper("tm_wdt", new WDT());
        }
        return this.peripheral;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public int getTimer() {
        return this.timer;
    }

    public class WDT
    extends TMLuaObject {
        @LuaMethod
        public boolean isEnabled() {
            return WatchDogTimerBlockEntity.this.enabled;
        }

        @LuaMethod
        public int getTimeout() {
            return WatchDogTimerBlockEntity.this.timeLimit;
        }

        @LuaMethod
        public void setEnabled(Object[] a) throws LuaException {
            if (a.length < 1) {
                throw new LuaException("Too few arguments (expected enable)");
            }
            boolean enable = ParamCheck.getBoolean(a, 0);
            Platform.getServer().execute(() -> {
                WatchDogTimerBlockEntity.this.enabled = enable;
                WatchDogTimerBlockEntity.this.timer = 0;
                WatchDogTimerBlockEntity.this.m_6596_();
            });
        }

        @LuaMethod
        public void setTimeout(Object[] a) throws LuaException {
            if (WatchDogTimerBlockEntity.this.enabled) {
                throw new LuaException("Can't edit timeout value while the timer is enabled");
            }
            if (a.length < 1) {
                throw new LuaException("Too few arguments (expected enable)");
            }
            int time = ParamCheck.getInt(a, 0);
            if (time < 20) {
                throw new LuaException("Bad argument #1 (expected value must be larger than 20 ticks)");
            }
            Platform.getServer().execute(() -> {
                WatchDogTimerBlockEntity.this.timeLimit = time;
                WatchDogTimerBlockEntity.this.timer = 0;
                WatchDogTimerBlockEntity.this.m_6596_();
            });
        }

        @LuaMethod
        public void reset() throws LuaException {
            Platform.getServer().execute(() -> {
                WatchDogTimerBlockEntity.this.timer = 0;
            });
        }
    }
}

