/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.client;

import com.tom.peripherals.block.entity.MonitorBlockEntity;
import com.tom.peripherals.cc.CCMonitor;
import com.tom.peripherals.client.MonHandler;
import com.tom.peripherals.client.MonitorHandler;
import com.tom.peripherals.network.Network;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlock;
import java.util.BitSet;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class KeyboardWidget
extends AbstractWidget {
    private final Minecraft mc = Minecraft.m_91087_();
    private float terminateTimer = -1.0f;
    private float rebootTimer = -1.0f;
    private float shutdownTimer = -1.0f;
    private final BitSet keysDown = new BitSet(256);
    private MonitorHandler monHandler;

    public KeyboardWidget() {
        super(0, 0, 0, 0, (Component)Component.m_237119_());
    }

    public boolean m_5534_(char ch, int modifiers) {
        if (ch >= ' ' && ch <= '~' || ch >= '\u00a0' && ch <= '\u00ff') {
            this.charType(ch);
        }
        return true;
    }

    public boolean m_7933_(int key, int scancode, int modifiers) {
        if (key == 256) {
            return false;
        }
        if ((modifiers & 2) != 0) {
            switch (key) {
                case 82: {
                    if (this.rebootTimer < 0.0f) {
                        this.rebootTimer = 0.0f;
                    }
                    return true;
                }
                case 83: {
                    if (this.shutdownTimer < 0.0f) {
                        this.shutdownTimer = 0.0f;
                    }
                    return true;
                }
                case 84: {
                    if (this.terminateTimer < 0.0f) {
                        this.terminateTimer = 0.0f;
                    }
                    return true;
                }
                default: {
                    break;
                }
                case 86: {
                    String clipboard = this.mc.f_91068_.m_90876_();
                    if (clipboard == null) break;
                    int newLineIndex1 = clipboard.indexOf("\r");
                    int newLineIndex2 = clipboard.indexOf("\n");
                    if (newLineIndex1 >= 0 && newLineIndex2 >= 0) {
                        clipboard = clipboard.substring(0, Math.min(newLineIndex1, newLineIndex2));
                    } else if (newLineIndex1 >= 0) {
                        clipboard = clipboard.substring(0, newLineIndex1);
                    } else if (newLineIndex2 >= 0) {
                        clipboard = clipboard.substring(0, newLineIndex2);
                    }
                    clipboard = SharedConstants.m_136190_((String)clipboard);
                    if (!clipboard.isEmpty()) {
                        if (clipboard.length() > 512) {
                            clipboard = clipboard.substring(0, 512);
                        }
                        this.pasteContent(clipboard);
                    }
                    return true;
                }
            }
        }
        if (key >= 0 && this.terminateTimer < 0.0f && this.rebootTimer < 0.0f && this.shutdownTimer < 0.0f) {
            boolean repeat = this.keysDown.get(key);
            this.keysDown.set(key);
            this.keyDown(key, repeat);
        }
        return true;
    }

    private void pasteContent(String clipboard) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("action", "paste");
        tag.m_128359_("v", clipboard);
        Network.sendToContainer(tag);
    }

    private void keyDown(int key, boolean repeat) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("action", "keyDown");
        tag.m_128405_("key", key);
        tag.m_128379_("r", repeat);
        Network.sendToContainer(tag);
    }

    private void keyUp(int key) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("action", "keyUp");
        tag.m_128405_("key", key);
        Network.sendToContainer(tag);
    }

    private void charType(char ch) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("action", "char");
        tag.m_128376_("char", (short)ch);
        Network.sendToContainer(tag);
    }

    private void queueEvent(String string) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("action", "event");
        tag.m_128359_("name", string);
        Network.sendToContainer(tag);
    }

    public boolean m_7920_(int key, int scancode, int modifiers) {
        if (key >= 0 && this.keysDown.get(key)) {
            this.keysDown.set(key, false);
            this.keyUp(key);
        }
        switch (key) {
            case 82: {
                this.rebootTimer = -1.0f;
                break;
            }
            case 83: {
                this.shutdownTimer = -1.0f;
                break;
            }
            case 84: {
                this.terminateTimer = -1.0f;
                break;
            }
            case 341: 
            case 345: {
                this.shutdownTimer = -1.0f;
                this.rebootTimer = -1.0f;
                this.terminateTimer = -1.0f;
            }
        }
        return true;
    }

    public void update() {
        if (this.terminateTimer >= 0.0f && this.terminateTimer < 0.5f) {
            float f;
            this.terminateTimer += 0.05f;
            if (f > 0.5f) {
                this.queueEvent("terminate");
            }
        }
        if (this.shutdownTimer >= 0.0f && this.shutdownTimer < 0.5f) {
            float f;
            this.shutdownTimer += 0.05f;
            if (f > 0.5f) {
                this.queueEvent("shutdown");
            }
        }
        if (this.rebootTimer >= 0.0f && this.rebootTimer < 0.5f) {
            float f;
            this.rebootTimer += 0.05f;
            if (f > 0.5f) {
                this.queueEvent("reboot");
            }
        }
    }

    public void m_87963_(GuiGraphics p_93657_, int p_93658_, int p_93659_, float p_93660_) {
        BlockHitResult lookingAt = (BlockHitResult)this.mc.f_91074_.m_19907_(32.0, 0.0f, true);
        BlockState state = this.mc.f_91073_.m_8055_(lookingAt.m_82425_());
        MonitorHandler mh = this.monHandler;
        BlockEntity blockEntity = this.mc.f_91073_.m_7702_(lookingAt.m_82425_());
        if (blockEntity instanceof MonitorBlockEntity) {
            MonitorBlockEntity be = (MonitorBlockEntity)blockEntity;
            MonitorHandler monitorHandler = this.monHandler;
            if (monitorHandler instanceof MonHandler) {
                h = (MonHandler)monitorHandler;
                ((MonHandler)h).setLookingAt(lookingAt, be);
            } else {
                mh = new MonHandler(lookingAt, be);
            }
        } else if (state.m_60734_() instanceof MonitorBlock) {
            MonitorHandler monitorHandler = this.monHandler;
            if (monitorHandler instanceof CCMonitor) {
                h = (CCMonitor)monitorHandler;
                ((CCMonitor)h).setLookingAt(lookingAt);
            } else {
                mh = new CCMonitor(lookingAt);
            }
        } else {
            mh = null;
        }
        if (mh != this.monHandler) {
            if (this.monHandler != null) {
                this.monHandler.onOffScreen();
            }
            this.monHandler = mh;
        }
    }

    public boolean m_6375_(double p_93641_, double p_93642_, int button) {
        if (this.monHandler != null) {
            this.monHandler.mouseClick(button + 1);
        }
        return true;
    }

    public boolean m_6348_(double p_93684_, double p_93685_, int button) {
        if (this.monHandler != null) {
            this.monHandler.mouseRelease(button + 1);
        }
        return true;
    }

    public boolean m_7979_(double p_93645_, double p_93646_, int button, double p_93648_, double p_93649_) {
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta != 0.0) {
            if (this.monHandler != null) {
                this.monHandler.mouseScroll(delta < 0.0 ? 1 : -1);
            }
            return true;
        }
        return false;
    }

    public void m_93692_(boolean focused) {
        if (!focused) {
            // empty if block
        }
    }

    public void release() {
        for (int key = 0; key < this.keysDown.size(); ++key) {
            if (!this.keysDown.get(key)) continue;
            this.keyUp(key);
        }
        this.keysDown.clear();
        if (this.monHandler != null) {
            this.monHandler.onOffScreen();
            this.monHandler = null;
        }
        this.rebootTimer = -1.0f;
        this.terminateTimer = -1.0f;
        this.shutdownTimer = -1.0f;
    }

    public boolean m_5953_(double p_93672_, double p_93673_) {
        return true;
    }

    public Component getInfo() {
        return this.monHandler != null ? this.monHandler.infoComponent() : Component.m_237119_();
    }

    protected void m_168797_(NarrationElementOutput p_259858_) {
    }
}

