/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.client;

import com.tom.peripherals.block.entity.MonitorBlockEntity;
import com.tom.peripherals.client.MonitorHandler;
import com.tom.peripherals.math.Vec2i;
import com.tom.peripherals.network.Network;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.BlockHitResult;

public class MonHandler
implements MonitorHandler {
    private BlockHitResult lookingAt;
    private Vec2i pos;
    private Vec2i lastPos;
    private BlockPos lastBPos;
    private int lastBtn;

    public MonHandler(BlockHitResult lookingAt, MonitorBlockEntity blockEntity) {
        this.setLookingAt(lookingAt, blockEntity);
        this.lastPos = this.pos;
        this.lastBPos = lookingAt.m_82425_();
    }

    @Override
    public void mouseClick(int btn) {
        this.sendEvent("mouse_click", this.lookingAt.m_82425_(), this.pos, btn);
        this.lastBtn = btn;
    }

    @Override
    public void mouseRelease(int btn) {
        if (this.lastBtn == btn) {
            this.sendEvent("mouse_up", this.lookingAt.m_82425_(), this.pos, btn);
            this.lastBtn = -1;
        }
    }

    @Override
    public void mouseScroll(int dir) {
        this.sendEvent("mouse_scroll", this.lookingAt.m_82425_(), this.pos, dir);
    }

    public void setLookingAt(BlockHitResult lookingAt, MonitorBlockEntity blockEntity) {
        Vec2i last = this.lastPos;
        BlockPos lastB = this.lastBPos;
        this.lastPos = this.pos;
        if (this.lookingAt != null) {
            this.lastBPos = this.lookingAt.m_82425_();
        }
        this.lookingAt = lookingAt;
        BlockPos pos = lookingAt.m_82425_();
        this.pos = blockEntity.getMonitorPixel(lookingAt.m_82434_(), lookingAt.m_82450_().f_82479_ - (double)pos.m_123341_(), lookingAt.m_82450_().f_82480_ - (double)pos.m_123342_(), lookingAt.m_82450_().f_82481_ - (double)pos.m_123343_());
        if (last != null) {
            if (this.pos.x != last.x || this.pos.y != last.y || !lastB.equals((Object)pos)) {
                if (this.lastBtn > 0) {
                    this.sendEvent("mouse_drag", pos, this.pos, this.lastBtn);
                } else {
                    this.sendEvent("mouse_move", pos, this.pos);
                }
            }
        } else {
            this.sendEvent("mouse_enter", lookingAt.m_82425_(), this.pos);
        }
    }

    private CompoundTag createTag(String event, BlockPos pos, Vec2i pixel) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("action", "monEvent");
        tag.m_128359_("event", event);
        tag.m_128405_("wx", pos.m_123341_());
        tag.m_128405_("wy", pos.m_123342_());
        tag.m_128405_("wz", pos.m_123343_());
        tag.m_128405_("x", pixel.x);
        tag.m_128405_("y", pixel.y);
        return tag;
    }

    private void sendEvent(String event, BlockPos pos, Vec2i pixel) {
        Network.sendToContainer(this.createTag(event, pos, pixel));
    }

    private void sendEvent(String event, BlockPos pos, Vec2i pixel, int param) {
        CompoundTag tag = this.createTag(event, pos, pixel);
        tag.m_128405_("param", param);
        Network.sendToContainer(tag);
    }

    @Override
    public void onOffScreen() {
        if (this.lastBtn > 0) {
            this.mouseRelease(this.lastBtn);
            this.lastBtn = -1;
        }
        this.sendEvent("mouse_exit", this.lookingAt.m_82425_(), this.pos);
    }

    @Override
    public Component infoComponent() {
        return Component.m_237115_((String)"label.toms_peripherals.keyboard.monitor");
    }
}

