/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.gpu;

import com.tom.peripherals.api.LuaException;
import com.tom.peripherals.api.LuaMethod;
import com.tom.peripherals.api.TMLuaObject;
import com.tom.peripherals.gpu.BaseGPU;
import com.tom.peripherals.gpu.GLConstants;
import com.tom.peripherals.gpu.TextureManager;
import com.tom.peripherals.gpu.TriBuilder;
import com.tom.peripherals.gpu.Triangle;
import com.tom.peripherals.gpu.VRAM;
import com.tom.peripherals.math.Matrix4d;
import com.tom.peripherals.math.Vec2d;
import com.tom.peripherals.math.Vec3d;
import com.tom.peripherals.math.Vec4d;
import com.tom.peripherals.util.ParamCheck;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;

public class GPU3D
extends TMLuaObject
implements VRAM.VRAMObject {
    protected TextureManager tm;
    protected TriBuilder buildingTri;
    protected Matrix4d mat = new Matrix4d().identity();
    protected Matrix4d proj = new Matrix4d();
    protected Stack<Matrix4d> mstack = new Stack();
    protected BaseGPU.GPUContext ctx;
    protected List<Triangle> triangles = new ArrayList<Triangle>();
    protected Vec3d nearPlane;
    protected Vec3d camera = new Vec3d();
    protected Vec3d directionalLight = new Vec3d();
    protected Vec4d color = new Vec4d(1.0, 1.0, 1.0, 1.0);
    protected float[] depthBuffer;

    public GPU3D(BaseGPU.GPUContext ctx) {
        this.ctx = ctx;
        this.tm = new TextureManager(ctx.getVRam());
        ctx.getVRam().alloc(this);
    }

    @LuaMethod
    public void glFrustum(Object[] a) throws LuaException {
        if (a.length < 3) {
            throw new LuaException("Too few arguments, expected: number fov, number Znear, number Zfar");
        }
        double fov = ParamCheck.getDouble(a, 0);
        double zNear = ParamCheck.getDouble(a, 1);
        double zFar = ParamCheck.getDouble(a, 2);
        double rtanFov = 1.0 / Math.tan(Math.toRadians(fov / 2.0));
        this.proj = new Matrix4d();
        this.proj.m00 = (double)this.ctx.getHeight() / (double)this.ctx.getWidth() * rtanFov;
        this.proj.m11 = rtanFov;
        this.proj.m22 = zFar / (zFar - zNear);
        this.proj.m23 = 1.0;
        this.proj.m32 = -zFar * zNear / (zFar - zNear);
        this.nearPlane = new Vec3d(0.0, 0.0, zNear);
    }

    @LuaMethod
    public void glDirLight(Object[] a) throws LuaException {
        if (a.length < 3) {
            throw new LuaException("Too few arguments, expected: number x, number y, number z");
        }
        this.directionalLight.x = ParamCheck.getDouble(a, 0);
        this.directionalLight.y = ParamCheck.getDouble(a, 1);
        this.directionalLight.z = ParamCheck.getDouble(a, 2);
        this.directionalLight = this.mat.mul(this.directionalLight);
        this.directionalLight.normalize();
    }

    @LuaMethod
    public void render() throws LuaException {
        int W = this.ctx.getWidth();
        int H = this.ctx.getHeight();
        if (this.depthBuffer == null || this.depthBuffer.length != W * H) {
            this.ctx.getVRam().reallocEx(this, W * H * 4 + 1024);
            this.depthBuffer = new float[W * H];
        }
        ArrayList<Triangle> tris = new ArrayList<Triangle>();
        for (Triangle tri : this.triangles) {
            double light = 1.0;
            Vec3d normal = tri.normal();
            double normalDot = normal.x * (tri.vert[0][0].x - this.camera.x) + normal.y * (tri.vert[0][0].y - this.camera.y) + normal.z * (tri.vert[0][0].z - this.camera.z);
            if (normalDot > 0.0) continue;
            light = normal.dotProduct(this.directionalLight);
            Triangle dup = new Triangle(tri);
            List<Triangle> clipped = dup.triangleClipAgainstPlane(this.nearPlane, new Vec3d(0.0, 0.0, 1.0));
            for (Triangle ctri : clipped) {
                Triangle nt = new Triangle(ctri);
                for (int i = 0; i < tri.vert.length; ++i) {
                    Vec4d vec3d = tri.vert[i][0];
                    Vec4d a = new Vec4d();
                    this.proj.mul(vec3d, a);
                    Vec4d uv = ctri.vert[i][1];
                    Vec4d nuv = new Vec4d();
                    double w = a.w;
                    if (w != 0.0) {
                        nuv.x = uv.x / w;
                        nuv.y = uv.y / w;
                        nuv.z = 1.0 / w;
                        a.x /= w;
                        a.y /= w;
                        a.z /= w;
                    }
                    a.x += 1.0;
                    a.y += 1.0;
                    a.x *= 0.5 * (double)W;
                    a.y *= 0.5 * (double)H;
                    nt.vert[i][0] = a;
                    Vec4d c = ctri.vert[i][2].mulI(light);
                    c.clip(0.0, 1.0);
                    nt.vert[i][2] = c;
                    nt.vert[i][1] = nuv;
                }
                tris.add(nt);
            }
        }
        tris.sort(Triangle.COMPARE_Z);
        for (Triangle tr : tris) {
            tr.clipAndBlit(this);
        }
    }

    @LuaMethod
    public void sync() throws LuaException {
        this.ctx.sync();
    }

    @LuaMethod
    public void clear() {
        for (int i = 0; i < this.ctx.getWidth(); ++i) {
            for (int j = 0; j < this.ctx.getHeight(); ++j) {
                this.ctx.set(i, j, 0);
            }
        }
        this.triangles.clear();
        this.mat.identity();
        if (this.depthBuffer != null) {
            Arrays.fill(this.depthBuffer, 0.0f);
        }
    }

    @LuaMethod
    public void glBegin(Object[] a) throws LuaException {
        if (this.buildingTri != null) {
            throw new LuaException("Already building");
        }
        int id = ParamCheck.optionalInt(a, 0, 4);
        this.buildingTri = TriBuilder.builder(id, this.triangles, () -> this.mat, this.tm::getTextureID);
    }

    @LuaMethod
    public void glEnd() throws LuaException {
        if (this.buildingTri == null) {
            throw new LuaException("not building");
        }
        this.buildingTri.finish();
        this.buildingTri = null;
    }

    @LuaMethod
    public void glVertex(Object[] a) throws LuaException {
        if (a.length < 3) {
            throw new LuaException("Too few arguments, expected: number x, number y, number z");
        }
        double x = ParamCheck.getDouble(a, 0);
        double y = ParamCheck.getDouble(a, 1);
        double z = ParamCheck.getDouble(a, 2);
        if (this.buildingTri == null) {
            throw new LuaException("not building");
        }
        this.buildingTri.append(new Vec3d(x, y, z));
        this.buildingTri.setColor(new Vec4d(this.color));
        this.buildingTri.setUV(new Vec2d());
    }

    @LuaMethod
    public void glTexCoord(Object[] a) throws LuaException {
        if (a.length < 2) {
            throw new LuaException("Too few arguments, expected: number u, number v");
        }
        double u = ParamCheck.getDouble(a, 0);
        double v = ParamCheck.getDouble(a, 1);
        if (this.buildingTri == null) {
            throw new LuaException("not building");
        }
        this.buildingTri.setUV(new Vec2d(u, v));
    }

    @LuaMethod
    public void glColor(Object[] a) throws LuaException {
        int c = ParamCheck.toColor(a, 0);
        this.color = new Vec4d((float)(c >> 16 & 0xFF) / 255.0f, (float)(c >> 8 & 0xFF) / 255.0f, (float)(c & 0xFF) / 255.0f, (float)(c >> 24 & 0xFF) / 255.0f);
        if (this.buildingTri != null) {
            this.buildingTri.setColor(new Vec4d(this.color));
        }
    }

    @LuaMethod
    public void glLoadIdentity() {
        this.mat.identity();
    }

    @LuaMethod
    public void glPushMatrix() {
        this.mstack.push(new Matrix4d(this.mat));
    }

    @LuaMethod
    public void glPopMatrix() throws LuaException {
        if (this.mstack.peek() == null) {
            throw new LuaException("no element in stack");
        }
        this.mat = this.mstack.pop();
    }

    @LuaMethod
    public void glTranslate(Object[] a) throws LuaException {
        if (a.length < 3) {
            throw new LuaException("Too few arguments, expected: number x, number y, number z");
        }
        double x = ParamCheck.getDouble(a, 0);
        double y = ParamCheck.getDouble(a, 1);
        double z = ParamCheck.getDouble(a, 2);
        this.mat.translate(x, y, z);
    }

    @LuaMethod
    public void glScale(Object[] a) throws LuaException {
        if (a.length < 3) {
            throw new LuaException("Too few arguments, expected: number x, number y, number z");
        }
        double x = ParamCheck.getDouble(a, 0);
        double y = ParamCheck.getDouble(a, 1);
        double z = ParamCheck.getDouble(a, 2);
        this.mat.scale(x, y, z);
    }

    @LuaMethod
    public void glRotate(Object[] a) throws LuaException {
        if (a.length < 4) {
            throw new LuaException("Too few arguments, expected: number angle, number x, number y, number z");
        }
        double d = ParamCheck.getDouble(a, 0);
        double x = ParamCheck.getDouble(a, 1);
        double y = ParamCheck.getDouble(a, 2);
        double z = ParamCheck.getDouble(a, 3);
        this.mat.rotate(Math.toRadians(d), x, y, z);
    }

    @LuaMethod
    public int glGenTextures(Object[] a) throws LuaException {
        return this.tm.genTextureID(a);
    }

    @LuaMethod
    public void glDeleteTextures(Object[] a) throws LuaException {
        this.tm.deleteTextures(a);
    }

    @LuaMethod
    public void glBindTexture(Object[] a) throws LuaException {
        this.tm.bindTexture(a);
    }

    @LuaMethod
    public void glTexImage(Object[] a) throws LuaException {
        this.tm.texImage(a);
    }

    @LuaMethod
    public Object getBounds() throws LuaException {
        return this.ctx.getBounds();
    }

    @Override
    public long getSize() {
        return (this.depthBuffer != null ? this.depthBuffer.length * 4 : 0) + 1024;
    }

    @LuaMethod
    public void glEnable(Object[] a) throws LuaException {
        int mode = ParamCheck.getInt(a, 0);
        switch (mode) {
            case 3553: {
                this.tm.setTexEnabled(true);
                break;
            }
            default: {
                throw new LuaException("Bad argument #1: unknown GL state" + mode);
            }
        }
    }

    @LuaMethod
    public void glDisable(Object[] a) throws LuaException {
        int mode = ParamCheck.getInt(a, 0);
        switch (mode) {
            case 3553: {
                this.tm.setTexEnabled(false);
                break;
            }
            default: {
                throw new LuaException("Bad argument #1: unknown GL state" + mode);
            }
        }
    }

    @LuaMethod
    public Object[] getConstants() {
        return GLConstants.ALL_CONST;
    }
}

