/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.menu;

import com.tom.peripherals.Content;
import com.tom.peripherals.block.entity.KeyboardBlockEntity;
import com.tom.peripherals.block.entity.MonitorBlockEntity;
import com.tom.peripherals.util.IDataReceiver;
import dan200.computercraft.shared.container.InvisibleSlot;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class KeyboardMenu
extends AbstractContainerMenu
implements IDataReceiver {
    private KeyboardBlockEntity te;
    private Inventory inv;
    private int randomId;

    public KeyboardMenu(int id, Inventory inv) {
        super(Content.keyboardMenu.get(), id);
        this.inv = inv;
        this.addSlots(inv);
    }

    public KeyboardMenu(int id, Inventory inv, KeyboardBlockEntity te) {
        this(id, inv);
        this.te = te;
        te.onKeyboardOpen(this.randomId);
        this.randomId = (int)(Math.random() * 2.147483647E9);
    }

    private void addSlots(Inventory player) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_((Slot)new InvisibleSlot((Container)player, i));
        }
    }

    public ItemStack m_7648_(Player player, int slot) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return this.te == null ? true : this.te.menuStillValid(player);
    }

    public void m_6877_(Player p_38940_) {
        super.m_6877_(p_38940_);
        if (this.te != null) {
            this.te.onKeyboardClosed(this.randomId);
        }
    }

    @Override
    public void receive(CompoundTag tag) {
        switch (tag.m_128461_("action")) {
            case "paste": {
                String text = tag.m_128461_("v");
                this.queueEvent("paste", text);
                break;
            }
            case "keyDown": {
                int key = tag.m_128451_("key");
                boolean rep = tag.m_128471_("r");
                this.queueEvent("key", key, rep);
                break;
            }
            case "keyUp": {
                int key = tag.m_128451_("key");
                this.queueEvent("key_up", key);
                break;
            }
            case "char": {
                short sh = tag.m_128448_("char");
                this.queueEvent("char", Character.toString(sh));
                break;
            }
            case "event": {
                this.queueEvent(tag.m_128461_("name"), new Object[0]);
                break;
            }
            case "clickCC": {
                BlockState b;
                int wx = tag.m_128451_("wx");
                int wy = tag.m_128451_("wy");
                int wz = tag.m_128451_("wz");
                double x = tag.m_128459_("x");
                double y = tag.m_128459_("y");
                double z = tag.m_128459_("z");
                byte d = tag.m_128445_("d");
                Direction dir = Direction.values()[Math.abs(d) % 6];
                BlockPos pos = new BlockPos(wx, wy, wz);
                BlockHitResult hit = new BlockHitResult(new Vec3(x, y, z), dir, pos, false);
                if (!this.te.m_58904_().m_46749_(pos) || !(this.te.m_58899_().m_123331_((Vec3i)pos) < 4096.0) || !((b = this.te.m_58904_().m_8055_(pos)).m_60734_() instanceof MonitorBlock)) break;
                b.m_60664_(this.te.m_58904_(), this.inv.f_35978_, InteractionHand.MAIN_HAND, hit);
                break;
            }
            case "monEvent": {
                BlockEntity blockEntity;
                Integer param;
                String ev = tag.m_128461_("event");
                int wx = tag.m_128451_("wx");
                int wy = tag.m_128451_("wy");
                int wz = tag.m_128451_("wz");
                int x = tag.m_128451_("x");
                int y = tag.m_128451_("y");
                BlockPos pos = new BlockPos(wx, wy, wz);
                Integer n = param = tag.m_128441_("param") ? Integer.valueOf(tag.m_128451_("param")) : null;
                if (!this.te.m_58904_().m_46749_(pos) || !(this.te.m_58899_().m_123331_((Vec3i)pos) < 4096.0) || !((blockEntity = this.te.m_58904_().m_7702_(pos)) instanceof MonitorBlockEntity)) break;
                MonitorBlockEntity be = (MonitorBlockEntity)blockEntity;
                be.event(ev, x, y, param);
                break;
            }
        }
    }

    private void queueEvent(String event, Object ... args) {
        this.te.queueEvent(event, args);
    }
}

