/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.screen;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.tom.peripherals.block.entity.MonitorBlockEntity;
import com.tom.peripherals.screen.TextureCache;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.system.MemoryUtil;

public class TextureCacheImpl
implements TextureCache {
    private final DynamicTexture dynTex;
    private final ResourceLocation loc;
    private NativeImage image;
    private IntBuffer buffer;
    private MonitorBlockEntity be;
    private boolean needsUpdate;

    public TextureCacheImpl(MonitorBlockEntity be) {
        this.be = be;
        this.needsUpdate = true;
        this.dynTex = new DynamicTexture(16, 16, true);
        this.loc = Minecraft.m_91087_().m_91097_().m_118490_("toms_peripherals", this.dynTex);
    }

    @Override
    public void invalidate() {
        this.needsUpdate = true;
    }

    @Override
    public void cleanup() {
        this.be = null;
        Minecraft.m_91087_().m_91097_().m_118513_(this.loc);
    }

    @Override
    public ResourceLocation getTexture() {
        if (this.be == null || this.be.screen.length == 0) {
            return null;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91097_().m_118506_(this.loc) == null) {
            mc.m_91097_().m_118495_(this.loc, (AbstractTexture)this.dynTex);
        }
        if (this.needsUpdate) {
            this.load(this.be.width, this.be.screen);
            this.needsUpdate = false;
        }
        return this.loc;
    }

    private void load(int w, int[] img) {
        int h = img.length / w;
        if (img.length != w * h) {
            System.err.println("Attempting to load an invalid texture");
            return;
        }
        if (this.image == null) {
            this.image = new NativeImage(w, h, false);
            this.getBuffer();
        } else if (this.image.m_84982_() != w || this.image.m_85084_() != h) {
            this.image.close();
            this.image = new NativeImage(w, h, false);
            this.getBuffer();
        }
        this.buffer.rewind();
        this.buffer.put(img);
        this.dynTex.m_117985_();
    }

    private void getBuffer() {
        this.dynTex.m_117988_(this.image);
        TextureUtil.prepareImage((int)this.dynTex.m_117963_(), (int)this.image.m_84982_(), (int)this.image.m_85084_());
        this.buffer = MemoryUtil.memIntBuffer((long)this.image.f_84964_, (int)(this.image.m_84982_() * this.image.m_85084_()));
    }
}

