/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation;

import com.github.tartaricacid.touhoulittlemaid.client.animation.inner.InnerAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;
import org.openjdk.nashorn.api.scripting.NashornScriptEngineFactory;

@OnlyIn(value=Dist.CLIENT)
public class CustomJsAnimationManger {
    public static final ScriptEngine NASHORN = new NashornScriptEngineFactory().getScriptEngine();
    private static final Map<ResourceLocation, Object> CUSTOM_ANIMATION_MAP = Maps.newHashMap();

    @Nullable
    public static List<Object> getCustomAnimation(Path rootPath, IModelInfo item) {
        ArrayList animations = Lists.newArrayList();
        if (item.getAnimation() != null && !item.getAnimation().isEmpty()) {
            for (ResourceLocation res : item.getAnimation()) {
                Object animation = CustomJsAnimationManger.getCustomAnimation(rootPath, res);
                if (animation == null) continue;
                animations.add(animation);
            }
            return animations;
        }
        return null;
    }

    @Nullable
    public static List<Object> getCustomAnimation(ZipFile zipFile, IModelInfo item) {
        ArrayList animations = Lists.newArrayList();
        if (item.getAnimation() != null && !item.getAnimation().isEmpty()) {
            for (ResourceLocation res : item.getAnimation()) {
                Object animation = CustomJsAnimationManger.getCustomAnimation(zipFile, res);
                if (animation == null) continue;
                animations.add(animation);
            }
            return animations;
        }
        return null;
    }

    @Nullable
    private static Object getCustomAnimation(Path rootPath, @Nullable ResourceLocation resourceLocation) {
        Object object;
        if (resourceLocation == null) {
            return null;
        }
        if (CUSTOM_ANIMATION_MAP.containsKey(resourceLocation)) {
            return CUSTOM_ANIMATION_MAP.get(resourceLocation);
        }
        if (InnerAnimation.containsKey(resourceLocation)) {
            return InnerAnimation.get(resourceLocation);
        }
        File file = rootPath.resolve("assets").resolve(resourceLocation.m_135827_()).resolve(resourceLocation.m_135815_()).toFile();
        if (!file.isFile()) {
            return null;
        }
        FileInputStream stream = new FileInputStream(file);
        try {
            Bindings bindings = NASHORN.createBindings();
            Object scriptObject = NASHORN.eval(IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8), bindings);
            CUSTOM_ANIMATION_MAP.put(resourceLocation, scriptObject);
            object = scriptObject;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ScriptException e) {
                e.printStackTrace();
                return null;
            }
        }
        ((InputStream)stream).close();
        return object;
    }

    @Nullable
    private static Object getCustomAnimation(ZipFile zipFile, @Nullable ResourceLocation resourceLocation) {
        Object object;
        block12: {
            if (resourceLocation == null) {
                return null;
            }
            if (CUSTOM_ANIMATION_MAP.containsKey(resourceLocation)) {
                return CUSTOM_ANIMATION_MAP.get(resourceLocation);
            }
            if (InnerAnimation.containsKey(resourceLocation)) {
                return InnerAnimation.get(resourceLocation);
            }
            ZipEntry entry = zipFile.getEntry(String.format("assets/%s/%s", resourceLocation.m_135827_(), resourceLocation.m_135815_()));
            if (entry == null) {
                return null;
            }
            InputStream stream = zipFile.getInputStream(entry);
            try {
                Bindings bindings = NASHORN.createBindings();
                Object scriptObject = NASHORN.eval(IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8), bindings);
                CUSTOM_ANIMATION_MAP.put(resourceLocation, scriptObject);
                object = scriptObject;
                if (stream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ScriptException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            stream.close();
        }
        return object;
    }

    public static void clearAll() {
        CUSTOM_ANIMATION_MAP.clear();
    }
}

