/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.event;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.ai.AIChatScreen;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class PressAIChatKeyEvent {
    public static final Set<String> CAN_CHAT_MAID_IDS = Sets.newHashSet();

    @SubscribeEvent
    public static void onOpenConfig(InputEvent.Key event) {
        if (PressAIChatKeyEvent.isInGame() && PressAIChatKeyEvent.keyIsMatch(event)) {
            EntityMaid maid = PressAIChatKeyEvent.maidCheck();
            if (maid == null) {
                return;
            }
            Minecraft.m_91087_().f_91066_.f_92098_.m_90859_();
            Minecraft.m_91087_().m_91152_((Screen)new AIChatScreen(maid));
        }
    }

    private static boolean keyIsMatch(InputEvent.Key event) {
        KeyMapping keyChat = Minecraft.m_91087_().f_91066_.f_92098_;
        return event.getAction() == 1 && keyChat.m_90832_(event.getKey(), event.getScanCode()) && keyChat.getKeyModifier().equals((Object)KeyModifier.getActiveModifier());
    }

    @Nullable
    private static EntityMaid maidCheck() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || player.m_5833_()) {
            return null;
        }
        Minecraft mc = Minecraft.m_91087_();
        HitResult hitResult = mc.f_91077_;
        if (!(hitResult instanceof EntityHitResult)) {
            return null;
        }
        EntityHitResult entityHitResult = (EntityHitResult)hitResult;
        Entity entity = entityHitResult.m_82443_();
        if (!(entity instanceof EntityMaid)) {
            return null;
        }
        EntityMaid maid = (EntityMaid)entity;
        if (!maid.m_21830_((LivingEntity)player)) {
            return null;
        }
        String modelId = maid.getModelId();
        if (CAN_CHAT_MAID_IDS.contains(modelId)) {
            return maid;
        }
        return null;
    }

    private static boolean isInGame() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91265_() != null) {
            return false;
        }
        if (mc.f_91080_ != null) {
            return false;
        }
        if (!mc.f_91067_.m_91600_()) {
            return false;
        }
        return mc.m_91302_();
    }
}

