/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MaidConfigButton
extends Button {
    private static final ResourceLocation ICON = new ResourceLocation("touhou_little_maid", "textures/gui/maid_gui_button.png");
    private final OnPress leftPress;
    private final OnPress rightPress;
    private boolean leftClicked = false;
    private Component value;

    public MaidConfigButton(int x, int y, Component title, Component value, OnPress onLeftPressIn, OnPress onRightPressIn) {
        super(Button.m_253074_((Component)title, b -> {}).m_252794_(x, y).m_253046_(164, 13));
        this.leftPress = onLeftPressIn;
        this.rightPress = onRightPressIn;
        this.value = value;
    }

    public MaidConfigButton(int x, int y, Component title, Component value, OnPress onPress) {
        this(x, y, title, value, onPress, onPress);
    }

    protected void m_87963_(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        Minecraft mc = Minecraft.m_91087_();
        RenderSystem.enableDepthTest();
        if (this.f_93622_) {
            graphics.m_280163_(ICON, this.m_252754_(), this.m_252907_(), 63.0f, 141.0f, this.f_93618_, this.f_93619_, 256, 256);
        } else {
            graphics.m_280163_(ICON, this.m_252754_(), this.m_252907_(), 63.0f, 128.0f, this.f_93618_, this.f_93619_, 256, 256);
        }
        graphics.m_280614_(mc.f_91062_, this.m_6035_(), this.m_252754_() + 5, this.m_252907_() + 3, 0x444444, false);
        this.drawCenteredStringWithoutShadow(graphics, mc.f_91062_, this.value, this.m_252754_() + 142, this.m_252907_() + 3, ChatFormatting.GREEN.m_126665_());
    }

    public void setValue(Component value) {
        this.value = value;
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        boolean clickY;
        if (!this.f_93623_ || !this.f_93624_) {
            return false;
        }
        boolean leftClickX = (double)(this.m_252754_() + 120) <= mouseX && mouseX <= (double)(this.m_252754_() + 130);
        boolean rightClickX = (double)(this.m_252754_() + 154) <= mouseX && mouseX <= (double)(this.m_252754_() + 164);
        boolean bl = clickY = (double)this.m_252907_() <= mouseY && mouseY <= (double)(this.m_252907_() + this.m_93694_());
        if (leftClickX && clickY) {
            this.leftClicked = true;
            return true;
        }
        if (rightClickX && clickY) {
            this.leftClicked = false;
            return true;
        }
        return false;
    }

    public void m_5691_() {
        if (this.leftClicked) {
            this.leftPress.onPress(this);
        } else {
            this.rightPress.onPress(this);
        }
    }

    public void drawCenteredStringWithoutShadow(GuiGraphics graphics, Font pFont, Component pText, int pX, int pY, int pColor) {
        FormattedCharSequence formattedcharsequence = pText.m_7532_();
        graphics.m_280649_(pFont, formattedcharsequence, pX - pFont.m_92724_(formattedcharsequence) / 2, pY, pColor, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnPress {
        public void onPress(MaidConfigButton var1);
    }
}

