/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.input;

import com.github.tartaricacid.touhoulittlemaid.ai.service.Service;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.player2.STTClient;
import com.github.tartaricacid.touhoulittlemaid.client.event.PressAIChatKeyEvent;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendUserChatMessage;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Comparator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class STTChatKey {
    public static final KeyMapping STT_CHAT_KEY = new KeyMapping("key.touhou_little_maid.stt_chat.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 88, "key.category.touhou_little_maid");
    private static final Timer TIMER = new Timer();

    @SubscribeEvent
    public static void onSttChatPress(InputEvent.Key event) {
        if (STT_CHAT_KEY.m_90832_(event.getKey(), event.getScanCode())) {
            if (!((Boolean)AIConfig.CHAT_ENABLED.get()).booleanValue()) {
                return;
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null || player.m_5833_()) {
                return;
            }
            if (!STTChatKey.isInGame()) {
                return;
            }
            if (event.getAction() == 1) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11871_, (float)2.0f));
                STTChatKey.sttStart();
            }
            if (event.getAction() == 0) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11871_, (float)0.5f));
                Level level = player.f_19853_;
                AABB aabb = player.m_20191_().m_82400_(12.0);
                final List maids = level.m_6443_(EntityMaid.class, aabb, maid -> maid.m_21830_((LivingEntity)player) && maid.m_6084_() && PressAIChatKeyEvent.CAN_CHAT_MAID_IDS.contains(maid.getModelId()));
                maids.sort(Comparator.comparingDouble(maid -> maid.m_20280_((Entity)player)));
                if (maids.isEmpty()) {
                    player.m_213846_((Component)Component.m_237115_((String)"ai.touhou_little_maid.stt.content.no_maid_found"));
                } else {
                    TIMER.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            STTChatKey.sttStop((EntityMaid)maids.get(0));
                        }
                    }, 1500L);
                }
            }
        }
    }

    private static boolean isInGame() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91265_() != null) {
            return false;
        }
        if (mc.f_91080_ != null) {
            return false;
        }
        if (!mc.f_91067_.m_91600_()) {
            return false;
        }
        return mc.m_91302_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void sttStart() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (((Boolean)AIConfig.CHAT_ENABLED.get()).booleanValue()) {
            String url = (String)AIConfig.STT_URL.get();
            if (StringUtils.isBlank((CharSequence)url)) {
                player.m_213846_((Component)Component.m_237115_((String)"ai.touhou_little_maid.chat.stt.empty"));
            } else {
                STTClient sttClient = Service.getSttClient(url);
                sttClient.start(message -> {}, throwable -> {
                    String cause = throwable.getLocalizedMessage();
                    player.m_213846_((Component)Component.m_237115_((String)"ai.touhou_little_maid.stt.connect.fail").m_130946_(cause).m_130940_(ChatFormatting.RED));
                });
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void sttStop(EntityMaid maid) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (!((Boolean)AIConfig.CHAT_ENABLED.get()).booleanValue()) {
            return;
        }
        String url = (String)AIConfig.STT_URL.get();
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        STTClient sttClient = Service.getSttClient(url);
        sttClient.stop(message -> {
            String chatText = message.getText();
            if (StringUtils.isNotBlank((CharSequence)chatText)) {
                LanguageManager languageManager = Minecraft.m_91087_().m_91102_();
                LanguageInfo info = languageManager.m_118976_(languageManager.m_264236_());
                String language = info != null ? info.m_264517_().getString() : "English (US)";
                NetworkHandler.CHANNEL.sendToServer((Object)new SendUserChatMessage(maid.m_19879_(), chatText, language));
                String name = player.m_6302_();
                String format = String.format("<%s> %s", name, chatText);
                player.m_213846_((Component)Component.m_237113_((String)format).m_130940_(ChatFormatting.GRAY));
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"ai.touhou_little_maid.stt.content.empty").m_130940_(ChatFormatting.GRAY));
            }
        }, throwable -> {
            String cause = throwable.getLocalizedMessage();
            player.m_213846_((Component)Component.m_237115_((String)"ai.touhou_little_maid.stt.connect.fail").m_130946_(cause).m_130940_(ChatFormatting.RED));
        });
    }
}

