/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.compat.oculus.OculusCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.MaidFishingHook;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class MaidFishingHookRenderer<T extends MaidFishingHook>
extends EntityRenderer<T> {
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("textures/entity/fishing_hook.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110452_((ResourceLocation)TEXTURE_LOCATION);

    public MaidFishingHookRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(T fishingHook, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        EntityMaid maid = ((MaidFishingHook)((Object)fishingHook)).getMaidOwner();
        if (maid == null) {
            return;
        }
        poseStack.m_85836_();
        this.renderBobber(fishingHook, poseStack, buffer, packedLight);
        this.renderFishingLine(fishingHook, partialTicks, poseStack, buffer, maid);
        poseStack.m_85849_();
        super.m_7392_(fishingHook, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    protected void renderBobber(T fishingHook, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        poseStack.m_252781_(this.f_114476_.m_253208_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        PoseStack.Pose lasted = poseStack.m_85850_();
        Matrix4f lastedPose = lasted.m_252922_();
        Matrix3f lastedNormal = lasted.m_252943_();
        VertexConsumer consumer = buffer.m_6299_(RENDER_TYPE);
        this.vertex(consumer, lastedPose, lastedNormal, packedLight, 0.0f, 0, 0, 1);
        this.vertex(consumer, lastedPose, lastedNormal, packedLight, 1.0f, 0, 1, 1);
        this.vertex(consumer, lastedPose, lastedNormal, packedLight, 1.0f, 1, 1, 0);
        this.vertex(consumer, lastedPose, lastedNormal, packedLight, 0.0f, 1, 0, 0);
        poseStack.m_85849_();
    }

    protected float[] getLineColor(T fishingHook) {
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    protected void renderFishingLine(T fishingHook, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, EntityMaid maid) {
        float lerpBodyRot;
        Entity entity = maid.m_20202_();
        if (entity instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)entity;
            lerpBodyRot = Mth.m_14179_((float)partialTicks, (float)vehicle.f_20884_, (float)vehicle.f_20883_) * ((float)Math.PI / 180);
        } else {
            lerpBodyRot = Mth.m_14179_((float)partialTicks, (float)maid.f_20884_, (float)maid.f_20883_) * ((float)Math.PI / 180);
        }
        double sin = Mth.m_14031_((float)lerpBodyRot);
        double cos = Mth.m_14089_((float)lerpBodyRot);
        double x1 = Mth.m_14139_((double)partialTicks, (double)maid.f_19854_, (double)maid.m_20185_()) - cos * 0.35 - sin * 0.8;
        double y1 = maid.f_19855_ + (double)maid.m_20192_() + (maid.m_20186_() - maid.f_19855_) * (double)partialTicks - 0.45;
        double z1 = Mth.m_14139_((double)partialTicks, (double)maid.f_19856_, (double)maid.m_20189_()) - sin * 0.35 + cos * 0.8;
        double x2 = Mth.m_14139_((double)partialTicks, (double)((MaidFishingHook)((Object)fishingHook)).f_19854_, (double)fishingHook.m_20185_());
        double y2 = Mth.m_14139_((double)partialTicks, (double)((MaidFishingHook)((Object)fishingHook)).f_19855_, (double)fishingHook.m_20186_()) + 0.25;
        double z2 = Mth.m_14139_((double)partialTicks, (double)((MaidFishingHook)((Object)fishingHook)).f_19856_, (double)fishingHook.m_20189_());
        float x = (float)(x1 - x2);
        float y = (float)(y1 - y2) - 0.1875f;
        float z = (float)(z1 - z2);
        float[] colors = this.getLineColor(fishingHook);
        VertexConsumer lineConsumer = buffer.m_6299_(RenderType.m_173247_());
        PoseStack.Pose lasted = poseStack.m_85850_();
        for (int i = 0; i <= 16; ++i) {
            this.stringVertex(x, y, z, lineConsumer, lasted, this.fraction(i), this.fraction(i + 1), colors[0], colors[1], colors[2]);
        }
        if (OculusCompat.isOculusInstalled()) {
            lineConsumer.m_5483_(0.0, 0.0, 0.0).m_6122_(0, 0, 0, 255).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
        }
    }

    protected float fraction(int numerator) {
        return (float)numerator / 16.0f;
    }

    protected void vertex(VertexConsumer consumer, Matrix4f pose, Matrix3f normal, int lightMapUV, float pX, int pY, int pU, int pV) {
        consumer.m_252986_(pose, pX - 0.5f, (float)pY - 0.5f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)pU, (float)pV).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMapUV).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    protected static void renderPosTexture(VertexConsumer builder, Matrix4f matrix4f, Matrix3f matrix3f, int lightMapUV, float x, int y, int u, int v) {
        builder.m_252986_(matrix4f, x - 0.5f, (float)y - 0.5f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)u, (float)v).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMapUV).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    protected static void vertex(VertexConsumer builder, Matrix4f matrix4f, Matrix3f matrix3f, int lightMapUV, float x, int y, int u, int v, float r, float g, float b) {
        builder.m_252986_(matrix4f, x - 0.5f, (float)y - 0.5f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_((float)u, (float)v).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMapUV).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    protected void stringVertex(float pX, float pY, float pZ, VertexConsumer consumer, PoseStack.Pose pose, float fraction1, float fraction2, float r, float g, float b) {
        float x = pX * fraction1;
        float y = pY * (fraction1 * fraction1 + fraction1) * 0.5f + 0.25f;
        float z = pZ * fraction1;
        float nx = pX * fraction2 - x;
        float ny = pY * (fraction2 * fraction2 + fraction2) * 0.5f + 0.25f - y;
        float nz = pZ * fraction2 - z;
        float sqrt = Mth.m_14116_((float)(nx * nx + ny * ny + nz * nz));
        consumer.m_252986_(pose.m_252922_(), x, y, z).m_85950_(r, g, b, 1.0f).m_252939_(pose.m_252943_(), nx /= sqrt, ny /= sqrt, nz /= sqrt).m_5752_();
    }

    public ResourceLocation getTextureLocation(T pEntity) {
        return TEXTURE_LOCATION;
    }
}

