/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.api.client.render.MaidRenderState;
import com.github.tartaricacid.touhoulittlemaid.client.model.StatueBaseModel;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGarageKit;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class TileEntityGarageKitRenderer
implements BlockEntityRenderer<TileEntityGarageKit> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/statue_base.png");
    private final StatueBaseModel BASE_MODEL;

    public TileEntityGarageKitRenderer(BlockEntityRendererProvider.Context context) {
        this.BASE_MODEL = new StatueBaseModel(context.m_173582_(StatueBaseModel.LAYER));
    }

    public void render(TileEntityGarageKit te, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        poseStack.m_85836_();
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        poseStack.m_85837_(1.0, 0.5, 1.0);
        poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
        VertexConsumer buffer = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE));
        this.BASE_MODEL.m_7695_(poseStack, buffer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        CompoundTag data = te.getExtraData();
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (data.m_128456_() || world == null) {
            return;
        }
        EntityType.m_20632_((String)data.m_128461_("id")).ifPresent(arg_0 -> this.lambda$render$0(te, poseStack, bufferIn, combinedLightIn, data, (Level)world, arg_0));
    }

    private void renderEntity(TileEntityGarageKit te, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, CompoundTag data, Level world, EntityType<?> type) throws ExecutionException {
        Entity entity;
        if (type.equals(InitEntities.MAID.get())) {
            long posId = te.m_58899_().m_121878_();
            entity = (Entity)EntityCacheUtil.STATUE_CACHE.get((Object)posId, () -> new EntityMaid(world));
        } else {
            entity = (Entity)EntityCacheUtil.ENTITY_CACHE.get(type, () -> {
                Entity e = type.m_20615_(world);
                return Objects.requireNonNullElseGet(e, () -> new EntityMaid(world));
            });
        }
        entity.m_20258_(data);
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            EntityCacheUtil.clearMaidDataResidue(maid, true);
            maid.renderState = MaidRenderState.GARAGE_KIT;
        }
        poseStack.m_85836_();
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        poseStack.m_85837_(1.0, 0.21328125, 1.0);
        switch (te.getFacing()) {
            case EAST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case WEST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                break;
            }
            case SOUTH: {
                break;
            }
            default: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            }
        }
        EntityRenderDispatcher render = Minecraft.m_91087_().m_91290_();
        boolean isShowHitBox = render.m_114377_();
        render.m_114473_(false);
        render.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, bufferIn, combinedLightIn);
        render.m_114473_(isShowHitBox);
        poseStack.m_85849_();
    }

    private /* synthetic */ void lambda$render$0(TileEntityGarageKit te, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, CompoundTag data, Level world, EntityType type) {
        try {
            this.renderEntity(te, poseStack, bufferIn, combinedLightIn, data, world, type);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }
}

