/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.tacz.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.compat.tacz.ai.GunAttackStrafingTask;
import com.github.tartaricacid.touhoulittlemaid.compat.tacz.ai.GunShootTargetTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRangedWalkToTarget;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidUseShieldTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.builder.GunItemBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class TaskGunAttack
implements IRangedAttackTask {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "gun_attack");
    private ItemStack icon;

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        ResourceLocation gunId = new ResourceLocation("tacz", "glock_17");
        if (this.icon == null) {
            TimelessAPI.getCommonGunIndex((ResourceLocation)gunId).ifPresentOrElse(index -> {
                this.icon = GunItemBuilder.create().setId(gunId).build();
            }, () -> {
                this.icon = ((Item)InitItems.TACZ_GUN_ICON.get()).m_7968_();
            });
        }
        return this.icon;
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound(maid, (SoundEvent)InitSounds.MAID_RANGE_ATTACK.get(), 0.5f);
    }

    @Override
    public boolean enableLookAndRandomWalk(EntityMaid maid) {
        return false;
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.m_257741_(this::mainhandHoldGun, IRangedAttackTask::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.m_257990_(target -> !this.mainhandHoldGun(maid) || this.farAway((LivingEntity)target, maid));
        BehaviorControl<EntityMaid> gunWalkTargetTask = MaidRangedWalkToTarget.create(0.6f);
        GunAttackStrafingTask gunAttackStrafingTask = new GunAttackStrafingTask();
        GunShootTargetTask gunShootTargetTask = new GunShootTargetTask();
        MaidUseShieldTask maidUseShieldTask = new MaidUseShieldTask();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, gunWalkTargetTask), Pair.of((Object)5, (Object)((Object)gunAttackStrafingTask)), Pair.of((Object)5, (Object)((Object)gunShootTargetTask)), Pair.of((Object)5, (Object)((Object)maidUseShieldTask))});
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.m_257741_(this::mainhandHoldGun, IRangedAttackTask::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.m_257990_(target -> !this.mainhandHoldGun(maid) || this.farAway((LivingEntity)target, maid));
        GunShootTargetTask gunShootTargetTask = new GunShootTargetTask();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)((Object)gunShootTargetTask))});
    }

    @Override
    public AABB searchDimension(EntityMaid maid) {
        if (IGun.mainhandHoldGun((LivingEntity)maid)) {
            float searchRange = this.searchRadius(maid);
            if (maid.m_21536_()) {
                return new AABB(maid.m_21534_()).m_82400_((double)searchRange);
            }
            return maid.m_20191_().m_82400_((double)searchRange);
        }
        return IRangedAttackTask.super.searchDimension(maid);
    }

    @Override
    public float searchRadius(EntityMaid maid) {
        return ((Integer)MaidConfig.MAID_GUN_LONG_DISTANCE.get()).intValue();
    }

    @Override
    public boolean canSee(EntityMaid maid, LivingEntity target) {
        ItemStack handItem = maid.m_21205_();
        IGun iGun = IGun.getIGunOrNull((ItemStack)handItem);
        if (iGun != null) {
            ResourceLocation gunId = iGun.getGunId(handItem);
            return TimelessAPI.getCommonGunIndex((ResourceLocation)gunId).map(index -> {
                String type = index.getType();
                String sniper = GunTabType.SNIPER.name().toLowerCase(Locale.ENGLISH);
                if (sniper.equals(type)) {
                    return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_LONG_DISTANCE);
                }
                String shotgun = GunTabType.SHOTGUN.name().toLowerCase(Locale.ENGLISH);
                String pistol = GunTabType.PISTOL.name().toLowerCase(Locale.ENGLISH);
                if (shotgun.equals(type) || pistol.equals(type)) {
                    return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_NEAR_DISTANCE);
                }
                return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_MEDIUM_DISTANCE);
            }).orElse(IRangedAttackTask.super.canSee(maid, target));
        }
        return IRangedAttackTask.super.canSee(maid, target);
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Collections.singletonList(Pair.of((Object)"has_tacz_gun", this::mainhandHoldGun));
    }

    private boolean mainhandHoldGun(EntityMaid maid) {
        return IGun.mainhandHoldGun((LivingEntity)maid);
    }

    private boolean farAway(LivingEntity target, EntityMaid maid) {
        return maid.m_20270_((Entity)target) > this.searchRadius(maid);
    }

    @Override
    public void performRangedAttack(EntityMaid shooter, LivingEntity target, float distanceFactor) {
    }
}

