/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.datagen;

import com.github.tartaricacid.touhoulittlemaid.datagen.AdvancementGenerator;
import com.github.tartaricacid.touhoulittlemaid.datagen.LootTableGenerator;
import com.github.tartaricacid.touhoulittlemaid.datagen.tag.DamageTypeGenerator;
import com.github.tartaricacid.touhoulittlemaid.datagen.tag.EntityTypeGenerator;
import com.github.tartaricacid.touhoulittlemaid.datagen.tag.TagBlock;
import com.github.tartaricacid.touhoulittlemaid.datagen.tag.TagItem;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="touhou_little_maid", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MaidDataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        DataGenerator.PackGenerator vanillaPack = generator.m_253147_(true);
        CompletableFuture registries = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(true, (DataProvider)new ForgeAdvancementProvider(packOutput, registries, existingFileHelper, Collections.singletonList(new AdvancementGenerator())));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Set.of(LootTableGenerator.CAKE), List.of(new LootTableProvider.SubProviderEntry(LootTableGenerator.AdvancementLootTables::new, LootContextParamSets.f_81418_))));
        TagBlock blockTagsProvider = (TagBlock)vanillaPack.m_253108_(output -> new TagBlock(output, registries, "touhou_little_maid", existingFileHelper));
        vanillaPack.m_253108_(output -> new TagItem(output, registries, blockTagsProvider.m_274426_(), "touhou_little_maid", existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DamageTypeGenerator(packOutput, registries, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new EntityTypeGenerator(packOutput, registries, existingFileHelper));
    }
}

