/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.datagen.advancement;

import com.github.tartaricacid.touhoulittlemaid.advancements.altar.AltarCraftTrigger;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.datagen.LanguageGenerator;
import com.github.tartaricacid.touhoulittlemaid.datagen.LootTableGenerator;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemEntityPlaceholder;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.RecipeCraftedTrigger;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BaseAdvancement {
    public static void generate(Consumer<Advancement> saver, ExistingFileHelper existingFileHelper) {
        Advancement root = BaseAdvancement.make((ItemLike)InitItems.HAKUREI_GOHEI.get(), "craft_gohei").m_138360_(RequirementsStrategy.f_15979_).m_138386_("craft_hakurei_gohei", (CriterionTriggerInstance)RecipeCraftedTrigger.TriggerInstance.m_280097_((ResourceLocation)BaseAdvancement.id("hakurei_gohei"))).m_138386_("craft_sanae_gohei", (CriterionTriggerInstance)RecipeCraftedTrigger.TriggerInstance.m_280097_((ResourceLocation)BaseAdvancement.id("sanae_gohei"))).m_138354_(AdvancementRewards.Builder.m_10005_((int)50)).save(saver, BaseAdvancement.id("base/craft_gohei"), existingFileHelper);
        BaseAdvancement.generateAltar(saver, existingFileHelper, root);
        BaseAdvancement.generateMaid(saver, existingFileHelper, root);
        BaseAdvancement.generateChair(saver, existingFileHelper, root);
    }

    private static void generateChair(Consumer<Advancement> saver, ExistingFileHelper existingFileHelper, Advancement root) {
        Advancement chair = BaseAdvancement.make((ItemLike)InitItems.CHAIR.get(), "craft_chair").m_138398_(root).m_138386_("craft_chair", (CriterionTriggerInstance)RecipeCraftedTrigger.TriggerInstance.m_280097_((ResourceLocation)BaseAdvancement.id("chair"))).save(saver, BaseAdvancement.id("base/craft_chair"), existingFileHelper);
        BaseAdvancement.make((ItemLike)InitItems.CHANGE_CHAIR_MODEL.get(), "change_chair_model").m_138398_(chair).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("change_chair_model")).save(saver, BaseAdvancement.id("base/change_chair_model"), existingFileHelper);
    }

    private static void generateMaid(Consumer<Advancement> saver, ExistingFileHelper existingFileHelper, Advancement root) {
        ItemStack stack = ItemEntityPlaceholder.setRecipeId(new ItemStack((ItemLike)InitItems.ENTITY_PLACEHOLDER.get()), BaseAdvancement.id("altar/spawn_box"));
        Advancement spawnMaid = BaseAdvancement.make(stack, "spawn_maid").m_138398_(root).m_138386_("altar_craft", (CriterionTriggerInstance)AltarCraftTrigger.Instance.recipe(BaseAdvancement.id("altar/spawn_box"))).m_138354_(AdvancementRewards.Builder.m_144822_((ResourceLocation)LootTableGenerator.CAKE)).save(saver, BaseAdvancement.id("base/spawn_maid"), existingFileHelper);
        BaseAdvancement.makeGoal((ItemLike)Items.f_42502_, "tamed_maid").m_138398_(spawnMaid).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("tamed_maid")).save(saver, BaseAdvancement.id("base/tamed_maid"), existingFileHelper);
        BaseAdvancement.make((ItemLike)InitItems.CHANGE_MAID_MODEL.get(), "change_maid_model").m_138398_(spawnMaid).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("change_maid_model")).save(saver, BaseAdvancement.id("base/change_maid_model"), existingFileHelper);
        BaseAdvancement.make((ItemLike)Items.f_41984_, "change_maid_sound").m_138398_(spawnMaid).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("change_maid_sound")).save(saver, BaseAdvancement.id("base/change_maid_sound"), existingFileHelper);
    }

    private static void generateAltar(Consumer<Advancement> saver, ExistingFileHelper existingFileHelper, Advancement root) {
        Advancement altar = BaseAdvancement.make((ItemLike)Items.f_41937_, "build_altar").m_138398_(root).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("build_altar")).m_138354_(AdvancementRewards.Builder.m_144822_((ResourceLocation)LootTableGenerator.POWER_POINT)).save(saver, BaseAdvancement.id("base/build_altar"), existingFileHelper);
        EntityPredicate.Builder predicate = EntityPredicate.Builder.m_36633_().m_36636_((EntityType)InitEntities.FAIRY.get());
        BaseAdvancement.make((ItemLike)InitItems.FAIRY_SPAWN_EGG.get(), "kill_maid_fairy").m_138398_(altar).m_138386_("killed_entity", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)predicate)).save(saver, BaseAdvancement.id("base/kill_maid_fairy"), existingFileHelper);
        BaseAdvancement.make((ItemLike)InitItems.POWER_POINT.get(), "pickup_power_point").m_138398_(altar).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("pickup_power_point")).save(saver, BaseAdvancement.id("base/pickup_power_point"), existingFileHelper);
    }

    private static Advancement.Builder make(ItemLike item, String key) {
        MutableComponent title = Component.m_237115_((String)String.format("advancements.touhou_little_maid.base.%s.title", key));
        MutableComponent desc = Component.m_237115_((String)String.format("advancements.touhou_little_maid.base.%s.description", key));
        LanguageGenerator.addLanguage(title);
        LanguageGenerator.addLanguage(desc);
        return Advancement.Builder.m_138353_().m_138371_(item, (Component)title, (Component)desc, new ResourceLocation("touhou_little_maid", "textures/advancements/backgrounds/stone.png"), FrameType.TASK, true, true, false);
    }

    private static Advancement.Builder make(ItemStack item, String key) {
        MutableComponent title = Component.m_237115_((String)String.format("advancements.touhou_little_maid.base.%s.title", key));
        MutableComponent desc = Component.m_237115_((String)String.format("advancements.touhou_little_maid.base.%s.description", key));
        LanguageGenerator.addLanguage(title);
        LanguageGenerator.addLanguage(desc);
        return Advancement.Builder.m_138353_().m_138362_(item, (Component)title, (Component)desc, new ResourceLocation("touhou_little_maid", "textures/advancements/backgrounds/stone.png"), FrameType.TASK, true, true, false);
    }

    private static Advancement.Builder makeGoal(ItemLike item, String key) {
        MutableComponent title = Component.m_237115_((String)String.format("advancements.touhou_little_maid.base.%s.title", key));
        MutableComponent desc = Component.m_237115_((String)String.format("advancements.touhou_little_maid.base.%s.description", key));
        LanguageGenerator.addLanguage(title);
        LanguageGenerator.addLanguage(desc);
        return Advancement.Builder.m_138353_().m_138371_(item, (Component)title, (Component)desc, new ResourceLocation("touhou_little_maid", "textures/advancements/backgrounds/stone.png"), FrameType.GOAL, true, true, false);
    }

    private static ResourceLocation id(String id) {
        return new ResourceLocation("touhou_little_maid", id);
    }
}

