/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.datagen.advancement;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.datagen.LanguageGenerator;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemEntityPlaceholder;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ChallengeAdvancement {
    public static void generate(Consumer<Advancement> saver, ExistingFileHelper existingFileHelper) {
        Advancement root = ChallengeAdvancement.make((ItemLike)Items.f_42468_, "any_equipment").m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("any_equipment")).save(saver, ChallengeAdvancement.id("challenge/any_equipment"), existingFileHelper);
        ChallengeAdvancement.generateProtect(root, saver, existingFileHelper);
        ChallengeAdvancement.generateKill(root, saver, existingFileHelper);
    }

    private static void generateProtect(Advancement root, Consumer<Advancement> saver, ExistingFileHelper existingFileHelper) {
        Advancement protect = ChallengeAdvancement.make((ItemLike)Items.f_42437_, "eat_enchanted_golden_apple").m_138398_(root).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("eat_enchanted_golden_apple")).save(saver, ChallengeAdvancement.id("challenge/eat_enchanted_golden_apple"), existingFileHelper);
        ChallengeAdvancement.makeChallenge((ItemLike)InitItems.ALL_NETHERITE_EQUIPMENT.get(), "all_netherite_equipment").m_138398_(protect).m_138354_(AdvancementRewards.Builder.m_10005_((int)50)).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("all_netherite_equipment")).save(saver, ChallengeAdvancement.id("challenge/all_netherite_equipment"), existingFileHelper);
        ItemStack stack = ItemEntityPlaceholder.setRecipeId(new ItemStack((ItemLike)InitItems.ENTITY_PLACEHOLDER.get()), ChallengeAdvancement.id("altar/spawn_lightning_bolt"));
        Advancement lightningBolt = ChallengeAdvancement.make(stack, "lightning_bolt").m_138398_(protect).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("lightning_bolt")).save(saver, ChallengeAdvancement.id("challenge/lightning_bolt"), existingFileHelper);
        ChallengeAdvancement.makeGoal((ItemLike)InitItems.MAID_100_HEALTHY.get(), "maid_100_healthy").m_138398_(lightningBolt).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("maid_100_healthy")).save(saver, ChallengeAdvancement.id("challenge/maid_100_healthy"), existingFileHelper);
    }

    private static void generateKill(Advancement root, Consumer<Advancement> saver, ExistingFileHelper existingFileHelper) {
        Advancement kill = ChallengeAdvancement.makeGoal((ItemLike)InitItems.KILL_100.get(), "kill_100").m_138398_(root).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("kill_100")).m_138354_(AdvancementRewards.Builder.m_10005_((int)50)).save(saver, ChallengeAdvancement.id("challenge/kill_100"), existingFileHelper);
        ChallengeAdvancement.makeChallenge((ItemLike)InitItems.KILL_SLIME_300.get(), "kill_slime_300").m_138398_(kill).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("kill_slime_300")).m_138354_(AdvancementRewards.Builder.m_10005_((int)50)).save(saver, ChallengeAdvancement.id("challenge/kill_slime_300"), existingFileHelper);
        Advancement wither = ChallengeAdvancement.makeChallenge((ItemLike)InitItems.KILL_WITHER.get(), "kill_wither").m_138398_(kill).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("kill_wither")).save(saver, ChallengeAdvancement.id("challenge/kill_wither"), existingFileHelper);
        ChallengeAdvancement.makeChallenge((ItemLike)InitItems.KILL_DRAGON.get(), "kill_dragon").m_138398_(wither).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("kill_dragon")).save(saver, ChallengeAdvancement.id("challenge/kill_dragon"), existingFileHelper);
    }

    private static void generateOther(Advancement root, Consumer<Advancement> saver, ExistingFileHelper existingFileHelper) {
        ChallengeAdvancement.makeGoal((ItemLike)Items.f_42690_, "maid_fishing_enchanted_book").m_138398_(root).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("maid_fishing_enchanted_book")).save(saver, ChallengeAdvancement.id("challenge/maid_fishing_enchanted_book"), existingFileHelper);
        ChallengeAdvancement.makeGoal((ItemLike)Items.f_42502_, "tamed_maid_in_pillager_outpost").m_138398_(root).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("tamed_maid_from_structure")).save(saver, ChallengeAdvancement.id("challenge/tamed_maid_in_pillager_outpost"), existingFileHelper);
    }

    private static Advancement.Builder make(ItemLike item, String key) {
        MutableComponent title = Component.m_237115_((String)String.format("advancements.touhou_little_maid.challenge.%s.title", key));
        MutableComponent desc = Component.m_237115_((String)String.format("advancements.touhou_little_maid.challenge.%s.description", key));
        LanguageGenerator.addLanguage(title);
        LanguageGenerator.addLanguage(desc);
        return Advancement.Builder.m_138353_().m_138371_(item, (Component)title, (Component)desc, new ResourceLocation("touhou_little_maid", "textures/advancements/backgrounds/stone.png"), FrameType.TASK, true, true, false);
    }

    private static Advancement.Builder make(ItemStack item, String key) {
        MutableComponent title = Component.m_237115_((String)String.format("advancements.touhou_little_maid.challenge.%s.title", key));
        MutableComponent desc = Component.m_237115_((String)String.format("advancements.touhou_little_maid.challenge.%s.description", key));
        LanguageGenerator.addLanguage(title);
        LanguageGenerator.addLanguage(desc);
        return Advancement.Builder.m_138353_().m_138362_(item, (Component)title, (Component)desc, new ResourceLocation("touhou_little_maid", "textures/advancements/backgrounds/stone.png"), FrameType.TASK, true, true, false);
    }

    private static Advancement.Builder makeGoal(ItemLike item, String key) {
        MutableComponent title = Component.m_237115_((String)String.format("advancements.touhou_little_maid.challenge.%s.title", key));
        MutableComponent desc = Component.m_237115_((String)String.format("advancements.touhou_little_maid.challenge.%s.description", key));
        LanguageGenerator.addLanguage(title);
        LanguageGenerator.addLanguage(desc);
        return Advancement.Builder.m_138353_().m_138371_(item, (Component)title, (Component)desc, new ResourceLocation("touhou_little_maid", "textures/advancements/backgrounds/stone.png"), FrameType.GOAL, true, true, false);
    }

    private static Advancement.Builder makeChallenge(ItemLike item, String key) {
        MutableComponent title = Component.m_237115_((String)String.format("advancements.touhou_little_maid.challenge.%s.title", key));
        MutableComponent desc = Component.m_237115_((String)String.format("advancements.touhou_little_maid.challenge.%s.description", key));
        LanguageGenerator.addLanguage(title);
        LanguageGenerator.addLanguage(desc);
        return Advancement.Builder.m_138353_().m_138371_(item, (Component)title, (Component)desc, new ResourceLocation("touhou_little_maid", "textures/advancements/backgrounds/stone.png"), FrameType.CHALLENGE, true, true, false);
    }

    private static ResourceLocation id(String id) {
        return new ResourceLocation("touhou_little_maid", id);
    }
}

