/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SpawnParticleMessage;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class MaidBreathAirTask
extends Behavior<EntityMaid> {
    private static final int MAX_PROBABILITY = 5;
    private static final int AIR_SEARCH_RANGE = 16;

    public MaidBreathAirTask() {
        super((Map)ImmutableMap.of());
    }

    protected boolean checkExtraStartConditions(ServerLevel level, EntityMaid maid) {
        BlockPos target;
        if (maid.getSwimManager().isEatBreatheItem()) {
            return false;
        }
        if (maid.getSwimManager().isGoingToBreath() && maid.m_6274_().m_21874_(MemoryModuleType.f_26370_) && this.givesAir(maid, target = ((WalkTarget)maid.m_6274_().m_21952_(MemoryModuleType.f_26370_).get()).m_26420_().m_6675_()) && (!maid.m_21573_().m_26571_() || maid.m_20183_().m_123333_((Vec3i)target) <= 1)) {
            return false;
        }
        if (maid.m_20146_() >= 100) {
            return false;
        }
        if (MobEffectUtil.m_19588_((LivingEntity)maid)) {
            return false;
        }
        if (this.hasDrownBauble(maid)) {
            return false;
        }
        return !maid.m_6117_();
    }

    protected void start(ServerLevel level, EntityMaid maid, long gameTime) {
        if (this.eatBreatheItem(maid)) {
            return;
        }
        this.findAirPosition(level, maid);
    }

    private boolean hasDrownBauble(EntityMaid maid) {
        BaubleItemHandler maidBauble = maid.getMaidBauble();
        for (int i = 0; i < maidBauble.getSlots(); ++i) {
            if (!maidBauble.getStackInSlot(i).m_150930_((Item)InitItems.DROWN_PROTECT_BAUBLE.get())) continue;
            return true;
        }
        return false;
    }

    private boolean eatBreatheItem(EntityMaid maid) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack itemInHand = maid.m_21120_(hand);
            if (itemInHand.m_41619_() || !this.isBreatheFood(maid, itemInHand)) continue;
            this.startEatBreatheItem(maid, itemInHand, hand);
            return true;
        }
        InteractionHand eanHand = InteractionHand.OFF_HAND;
        for (InteractionHand hand : InteractionHand.values()) {
            if (!maid.m_21120_(hand).m_41619_()) continue;
            eanHand = hand;
            break;
        }
        ItemStack itemInHand = maid.m_21120_(eanHand);
        boolean hasFood = false;
        RangedWrapper backpackInv = maid.getAvailableBackpackInv();
        for (int i = 0; i < backpackInv.getSlots(); ++i) {
            ItemStack stack = backpackInv.getStackInSlot(i);
            if (stack.m_41619_() || !this.isBreatheFood(maid, stack)) continue;
            ItemStack foodStack = backpackInv.extractItem(i, backpackInv.getStackInSlot(i).m_41613_(), false);
            ItemStack handStack = itemInHand.m_41777_();
            maid.m_21008_(eanHand, foodStack);
            maid.memoryHandItemStack(handStack);
            itemInHand = maid.m_21120_(eanHand);
            hasFood = true;
            break;
        }
        if (hasFood) {
            this.startEatBreatheItem(maid, itemInHand, eanHand);
        }
        return hasFood;
    }

    private void startEatBreatheItem(EntityMaid maid, ItemStack stack, InteractionHand hand) {
        maid.getSwimManager().setEatBreatheItem(true);
        FoodProperties foodProperties = stack.getFoodProperties((LivingEntity)maid);
        float total = 0.0f;
        if (foodProperties != null) {
            int nutrition = foodProperties.m_38744_();
            float saturationModifier = foodProperties.m_38745_();
            total = (float)nutrition + (float)nutrition * saturationModifier * 2.0f;
        }
        maid.m_6672_(hand);
        if ((float)maid.m_217043_().m_188503_(5) < total) {
            float healCount = Math.max(total / 5.0f, 1.0f);
            maid.m_5634_(healCount);
            NetworkHandler.sendToNearby((Entity)maid, new SpawnParticleMessage(maid.m_19879_(), SpawnParticleMessage.Type.HEAL, stack.m_41779_()));
        }
    }

    private boolean isBreatheFood(EntityMaid maid, ItemStack stack) {
        if (stack.m_41720_() instanceof PotionItem) {
            List mobEffects = PotionUtils.m_43547_((ItemStack)stack);
            if (mobEffects.isEmpty()) {
                return false;
            }
            for (MobEffectInstance effect : mobEffects) {
                if (effect.m_19544_() != MobEffects.f_19608_) continue;
                return true;
            }
            return false;
        }
        FoodProperties foodProperties = stack.getFoodProperties((LivingEntity)maid);
        if (foodProperties == null) {
            return false;
        }
        List effects = foodProperties.m_38749_();
        if (effects.isEmpty()) {
            return false;
        }
        for (Pair effect : effects) {
            if (((MobEffectInstance)effect.getFirst()).m_19544_() != MobEffects.f_19608_) continue;
            return true;
        }
        return false;
    }

    private void findAirPosition(ServerLevel level, EntityMaid maid) {
        if (!maid.canBrainMoving()) {
            return;
        }
        NodeEvaluator nodeEvaluator = maid.m_21573_().m_26575_();
        MaidPathFindingBFS pathFinding = new MaidPathFindingBFS(nodeEvaluator, level, maid, 16.0f, 16);
        Optional<BlockPos> match = pathFinding.find(blockPos -> this.givesAir(maid, (BlockPos)blockPos));
        pathFinding.finish();
        if (match.isPresent() && maid.canPathReach(match.get())) {
            maid.getSwimManager().setGoingToBreath(true);
            BehaviorUtils.m_22617_((LivingEntity)maid, (BlockPos)match.get(), (float)0.5f, (int)1);
            return;
        }
        BlockPos.MutableBlockPos seaLevelPos = maid.m_20183_().m_122032_().m_142448_(level.m_5736_() + 1);
        if (this.givesAir(maid, (BlockPos)seaLevelPos) && maid.canPathReach((BlockPos)seaLevelPos)) {
            maid.getSwimManager().setGoingToBreath(true);
            BehaviorUtils.m_22617_((LivingEntity)maid, (BlockPos)seaLevelPos, (float)0.5f, (int)1);
            return;
        }
        int seaLevelOffset = 2;
        Iterable canBreathPos = BlockPos.m_121976_((int)(seaLevelPos.m_123341_() - 2), (int)seaLevelPos.m_123342_(), (int)(seaLevelPos.m_123343_() - 2), (int)(seaLevelPos.m_123341_() + 2), (int)seaLevelPos.m_123342_(), (int)(seaLevelPos.m_123343_() + 2));
        for (BlockPos canBreathPo : canBreathPos) {
            if (!this.givesAir(maid, canBreathPo) || !maid.canPathReach(canBreathPo)) continue;
            maid.getSwimManager().setGoingToBreath(true);
            BehaviorUtils.m_22617_((LivingEntity)maid, (BlockPos)canBreathPo, (float)0.5f, (int)1);
            return;
        }
    }

    private boolean givesAir(EntityMaid maid, BlockPos pos) {
        Level level = maid.f_19853_;
        BlockState blockState = level.m_8055_(pos);
        boolean noFluid = level.m_6425_(pos).m_76178_() || blockState.m_60713_(Blocks.f_50628_);
        return noFluid && blockState.m_60734_().m_7357_(blockState, (BlockGetter)level, pos, PathComputationType.LAND);
    }
}

