/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleManger;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.vehicle.Boat;

public class MaidFindSitTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 12;
    private final float speedModifier;
    private Entity sitEntity = null;

    public MaidFindSitTask(float speedModifier) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT));
        this.speedModifier = speedModifier;
        this.setMaxCheckRate(12);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        return super.checkExtraStartConditions(worldIn, owner) && owner.m_20202_() == null;
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        this.sitEntity = null;
        this.getEntities(maid).m_186128_(e -> this.filterEntity(maid, (Entity)e)).findFirst().ifPresentOrElse(entity -> {
            this.sitEntity = entity;
            BehaviorUtils.m_22590_((LivingEntity)maid, (Entity)this.sitEntity, (float)this.speedModifier, (int)0);
        }, () -> ChatBubbleManger.addInnerChatText(maid, "chat_bubble.touhou_little_maid.inner.fishing.no_sit"));
        if (this.sitEntity != null && this.sitEntity.m_6084_() && this.sitEntity.m_19950_((Entity)maid, 2.0)) {
            if (this.sitEntity.m_20197_().isEmpty()) {
                maid.m_7998_(this.sitEntity, true);
            }
            this.sitEntity = null;
        }
    }

    private boolean filterEntity(EntityMaid maid, Entity entity) {
        if (!entity.m_6084_()) {
            return false;
        }
        if (!maid.m_21444_(entity.m_20183_())) {
            return false;
        }
        if (!entity.m_20197_().isEmpty()) {
            return false;
        }
        return entity instanceof EntityChair || entity instanceof Boat;
    }

    private NearestVisibleLivingEntities getEntities(EntityMaid maid) {
        return maid.m_6274_().m_21952_(MemoryModuleType.f_148205_).orElse(NearestVisibleLivingEntities.m_186106_());
    }
}

