/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class MaidFollowOwnerTask
extends Behavior<EntityMaid> {
    private final float speedModifier;
    private final int stopDistance;

    public MaidFollowOwnerTask(float speedModifier, int stopDistance) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED));
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, EntityMaid maid) {
        return !maid.getSwimManager().isGoingToBreath();
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        LivingEntity owner = maid.m_269323_();
        int startDistance = (int)maid.m_21535_() - 2;
        int minTeleportDistance = startDistance + 4;
        if (this.ownerStateConditions(owner) && this.maidStateConditions(maid) && !maid.m_19950_((Entity)owner, startDistance)) {
            if (!maid.m_19950_((Entity)owner, minTeleportDistance)) {
                maid.teleportToOwner(owner);
                maid.getNavigationManager().resetNavigation();
            } else if (!this.ownerIsWalkTarget(maid, owner)) {
                BehaviorUtils.m_22590_((LivingEntity)maid, (Entity)owner, (float)this.speedModifier, (int)this.stopDistance);
            }
        }
    }

    private boolean maidStateConditions(EntityMaid maid) {
        return !maid.isHomeModeEnable() && maid.canBrainMoving();
    }

    private boolean ownerStateConditions(@Nullable LivingEntity owner) {
        return owner != null && !owner.m_5833_() && !owner.m_21224_();
    }

    private boolean ownerIsWalkTarget(EntityMaid maid, LivingEntity owner) {
        return maid.m_6274_().m_21952_(MemoryModuleType.f_26370_).map(target -> {
            if (target.m_26420_() instanceof EntityTracker) {
                return ((EntityTracker)target.m_26420_()).m_147481_().equals((Object)owner);
            }
            return false;
        }).orElse(false);
    }
}

