/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.api.mixin.IPlayerMixin;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.mixin.EntityAccessor;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class MaidFollowOwnerVehicleTask
extends Behavior<EntityMaid> {
    private static final int RANGE = 3;
    private final float speedModifier;
    private final int stopDistance;
    private Entity ownerControlledVehicle;
    private Type type = Type.NONE;

    public MaidFollowOwnerVehicleTask(float speedModifier, int stopDistance) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED));
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid maid) {
        if (!this.maidStateConditions(maid)) {
            return false;
        }
        LivingEntity owner = maid.m_269323_();
        if (!this.ownerStateConditions(owner) || !(owner instanceof Player)) {
            return false;
        }
        Player player = (Player)owner;
        Entity ownerControlledVehicle = owner.m_275832_();
        Entity maidVehicle = maid.m_20202_();
        if (ownerControlledVehicle == null) {
            boolean maidInDismountRange;
            boolean isCooldown = ((IPlayerMixin)player).tlmInRemoveVehicleCooldown();
            boolean bl = maidInDismountRange = maid.m_20270_((Entity)owner) < 3.0f;
            if (maid.m_20159_() && isCooldown && maidInDismountRange) {
                this.type = Type.STOP;
                return true;
            }
            return false;
        }
        if (maidVehicle != null && maidVehicle == ownerControlledVehicle) {
            return false;
        }
        if (!((EntityAccessor)ownerControlledVehicle).tlmCanAddPassenger((Entity)maid)) {
            return false;
        }
        if (maid.m_19950_(ownerControlledVehicle, 3.0)) {
            this.ownerControlledVehicle = ownerControlledVehicle;
            this.type = Type.RIDE;
            return true;
        }
        if (!maid.m_6274_().m_21874_(MemoryModuleType.f_26370_)) {
            BehaviorUtils.m_22590_((LivingEntity)maid, (Entity)ownerControlledVehicle, (float)this.speedModifier, (int)this.stopDistance);
            return false;
        }
        return false;
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        switch (this.type) {
            case RIDE: {
                Optional.ofNullable(this.ownerControlledVehicle).ifPresent(arg_0 -> ((EntityMaid)maid).m_20329_(arg_0));
                break;
            }
            case STOP: {
                maid.m_8127_();
            }
        }
    }

    protected void stop(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        this.ownerControlledVehicle = null;
        this.type = Type.NONE;
    }

    private boolean canBrainMoving(EntityMaid maid) {
        return !maid.isMaidInSittingPose() && !maid.m_5803_() && !maid.m_21523_();
    }

    private boolean maidStateConditions(EntityMaid maid) {
        return !maid.isHomeModeEnable() && this.canBrainMoving(maid) && maid.isRideable();
    }

    private boolean ownerStateConditions(@Nullable LivingEntity owner) {
        return owner != null && owner.m_6084_() && !owner.m_5833_() && !owner.m_21224_();
    }

    static enum Type {
        RIDE,
        STOP,
        NONE;

    }
}

