/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.mixin.FenceGateBlockAccessor;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.kinds.OptionalBox;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;

public class MaidInteractWithDoor {
    private static final int COOLDOWN_BEFORE_RERUNNING_IN_SAME_NODE = 3;
    private static final double SKIP_CLOSING_DOOR_IF_FURTHER_AWAY_THAN = 8.0;
    private static final double MAX_DISTANCE_TO_HOLD_DOOR_OPEN_FOR_OTHER_MOBS = 2.0;

    public static BehaviorControl<LivingEntity> create() {
        MutableObject mutableObject = new MutableObject();
        MutableInt mutableInt = new MutableInt();
        return BehaviorBuilder.m_258034_(instance -> instance.group((App)instance.m_257495_(MemoryModuleType.f_26377_), (App)instance.m_257492_(MemoryModuleType.f_26379_), (App)instance.m_257492_(MemoryModuleType.f_148204_)).apply((Applicative)instance, (pathMemory, doorToCloseMemory, livingEntityMemory) -> (serverLevel, entity, time) -> {
            Path path = (Path)instance.m_258051_(pathMemory);
            Optional<Set<GlobalPos>> doorToClosePos = instance.m_257828_(doorToCloseMemory);
            if (!path.m_77387_() && !path.m_77392_()) {
                EntityMaid maid;
                EntityMaid maid2;
                if (Objects.equals(mutableObject.getValue(), path.m_77401_())) {
                    mutableInt.setValue(3);
                } else if (mutableInt.decrementAndGet() > 0) {
                    return false;
                }
                boolean canOpenDoor = entity instanceof EntityMaid && (maid2 = (EntityMaid)entity).getConfigManager().isOpenDoor();
                boolean canOpenFenceGate = entity instanceof EntityMaid && (maid = (EntityMaid)entity).getConfigManager().isOpenFenceGate();
                mutableObject.setValue((Object)path.m_77401_());
                Node previousNode = path.m_77402_();
                Node nextNode = path.m_77401_();
                BlockPos previousNodeBlockPos = previousNode.m_77288_();
                BlockState previousNodeBlockState = serverLevel.m_8055_(previousNodeBlockPos);
                if (canOpenDoor && previousNodeBlockState.m_204338_(BlockTags.f_13095_, stateBase -> stateBase.m_60734_() instanceof DoorBlock)) {
                    DoorBlock doorBlock = (DoorBlock)previousNodeBlockState.m_60734_();
                    if (!doorBlock.m_52815_(previousNodeBlockState)) {
                        doorBlock.m_153165_((Entity)entity, (Level)serverLevel, previousNodeBlockState, previousNodeBlockPos, true);
                    }
                    doorToClosePos = MaidInteractWithDoor.rememberDoorToClose((MemoryAccessor<OptionalBox.Mu, Set<GlobalPos>>)doorToCloseMemory, doorToClosePos, serverLevel, previousNodeBlockPos);
                } else if (canOpenFenceGate && previousNodeBlockState.m_204338_(BlockTags.f_13055_, stateBase -> stateBase.m_60734_() instanceof FenceGateBlock)) {
                    if (!((Boolean)previousNodeBlockState.m_61143_((Property)FenceGateBlock.f_53341_)).booleanValue()) {
                        MaidInteractWithDoor.setFenceGate((Entity)entity, (Level)serverLevel, previousNodeBlockState, previousNodeBlockPos, true);
                    }
                    doorToClosePos = MaidInteractWithDoor.rememberDoorToClose((MemoryAccessor<OptionalBox.Mu, Set<GlobalPos>>)doorToCloseMemory, doorToClosePos, serverLevel, previousNodeBlockPos);
                }
                BlockPos nextNodeBlockPos = nextNode.m_77288_();
                BlockState nextNodeBlockState = serverLevel.m_8055_(nextNodeBlockPos);
                if (canOpenDoor && nextNodeBlockState.m_204338_(BlockTags.f_13095_, stateBase -> stateBase.m_60734_() instanceof DoorBlock)) {
                    DoorBlock doorBlock = (DoorBlock)nextNodeBlockState.m_60734_();
                    if (!doorBlock.m_52815_(nextNodeBlockState)) {
                        doorBlock.m_153165_((Entity)entity, (Level)serverLevel, nextNodeBlockState, nextNodeBlockPos, true);
                        doorToClosePos = MaidInteractWithDoor.rememberDoorToClose((MemoryAccessor<OptionalBox.Mu, Set<GlobalPos>>)doorToCloseMemory, doorToClosePos, serverLevel, nextNodeBlockPos);
                    }
                } else if (canOpenFenceGate && nextNodeBlockState.m_204338_(BlockTags.f_13055_, stateBase -> stateBase.m_60734_() instanceof FenceGateBlock) && !((Boolean)nextNodeBlockState.m_61143_((Property)FenceGateBlock.f_53341_)).booleanValue()) {
                    MaidInteractWithDoor.setFenceGate((Entity)entity, (Level)serverLevel, nextNodeBlockState, nextNodeBlockPos, true);
                    doorToClosePos = MaidInteractWithDoor.rememberDoorToClose((MemoryAccessor<OptionalBox.Mu, Set<GlobalPos>>)doorToCloseMemory, doorToClosePos, serverLevel, nextNodeBlockPos);
                }
                doorToClosePos.ifPresent(doorPos -> MaidInteractWithDoor.closeDoorsThatIHaveOpenedOrPassedThrough(serverLevel, entity, previousNode, nextNode, doorPos, instance.m_257828_(livingEntityMemory)));
                return true;
            }
            return false;
        }));
    }

    public static void closeDoorsThatIHaveOpenedOrPassedThrough(ServerLevel serverLevel, LivingEntity entity, @Nullable Node previous, @Nullable Node next, Set<GlobalPos> doorPositions, Optional<List<LivingEntity>> nearestLivingEntities) {
        Iterator<GlobalPos> doorPosIterator = doorPositions.iterator();
        while (doorPosIterator.hasNext()) {
            GlobalPos globalPos = doorPosIterator.next();
            BlockPos blockPos = globalPos.m_122646_();
            if (previous != null && previous.m_77288_().equals((Object)blockPos) && (next == null || !entity.m_20183_().equals((Object)next.m_77288_())) || next != null && next.m_77288_().equals((Object)blockPos)) continue;
            if (MaidInteractWithDoor.isDoorTooFarAway(serverLevel, entity, globalPos)) {
                doorPosIterator.remove();
                continue;
            }
            BlockState blockstate = serverLevel.m_8055_(blockPos);
            if (blockstate.m_204338_(BlockTags.f_13095_, stateBase -> stateBase.m_60734_() instanceof DoorBlock)) {
                DoorBlock doorblock = (DoorBlock)blockstate.m_60734_();
                if (!doorblock.m_52815_(blockstate)) {
                    doorPosIterator.remove();
                    continue;
                }
                if (MaidInteractWithDoor.areOtherMobsComingThroughDoor(entity, blockPos, nearestLivingEntities)) {
                    doorPosIterator.remove();
                    continue;
                }
                doorblock.m_153165_((Entity)entity, (Level)serverLevel, blockstate, blockPos, false);
                doorPosIterator.remove();
                continue;
            }
            if (blockstate.m_204338_(BlockTags.f_13055_, stateBase -> stateBase.m_60734_() instanceof FenceGateBlock)) {
                if (!((Boolean)blockstate.m_61143_((Property)FenceGateBlock.f_53341_)).booleanValue()) {
                    doorPosIterator.remove();
                    continue;
                }
                if (MaidInteractWithDoor.areOtherMobsComingThroughDoor(entity, blockPos, nearestLivingEntities)) {
                    doorPosIterator.remove();
                    continue;
                }
                MaidInteractWithDoor.setFenceGate((Entity)entity, (Level)serverLevel, blockstate, blockPos, false);
                continue;
            }
            doorPosIterator.remove();
        }
    }

    private static boolean areOtherMobsComingThroughDoor(LivingEntity entity, BlockPos pos, Optional<List<LivingEntity>> nearestLivingEntities) {
        return nearestLivingEntities.map(entities -> entities.stream().filter(livingEntity -> livingEntity.m_6095_() == entity.m_6095_()).filter(livingEntity -> pos.m_203195_((Position)livingEntity.m_20182_(), 2.0)).anyMatch(livingEntity -> MaidInteractWithDoor.isMobComingThroughDoor(livingEntity.m_6274_(), pos))).orElse(false);
    }

    private static boolean isMobComingThroughDoor(Brain<?> brain, BlockPos pos) {
        if (!brain.m_21874_(MemoryModuleType.f_26377_)) {
            return false;
        }
        Path path = (Path)brain.m_21952_(MemoryModuleType.f_26377_).get();
        if (path.m_77392_()) {
            return false;
        }
        Node previousNode = path.m_77402_();
        if (previousNode == null) {
            return false;
        }
        Node nextNode = path.m_77401_();
        return pos.equals((Object)previousNode.m_77288_()) || pos.equals((Object)nextNode.m_77288_());
    }

    private static boolean isDoorTooFarAway(ServerLevel level, LivingEntity entity, GlobalPos pos) {
        return pos.m_122640_() != level.m_46472_() || !pos.m_122646_().m_203195_((Position)entity.m_20182_(), 8.0);
    }

    private static Optional<Set<GlobalPos>> rememberDoorToClose(MemoryAccessor<OptionalBox.Mu, Set<GlobalPos>> doorsToClose, Optional<Set<GlobalPos>> doorPositions, ServerLevel level, BlockPos blockPos) {
        GlobalPos globalPos = GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)blockPos);
        return Optional.of(doorPositions.map(pos -> {
            pos.add(globalPos);
            return pos;
        }).orElseGet(() -> {
            HashSet posSet = Sets.newHashSet((Object[])new GlobalPos[]{globalPos});
            doorsToClose.m_257512_((Object)posSet);
            return posSet;
        }));
    }

    private static void setFenceGate(@Nullable Entity entity, Level serverLevel, BlockState blockstate, BlockPos blockPos, boolean isOpen) {
        serverLevel.m_7731_(blockPos, (BlockState)blockstate.m_61124_((Property)FenceGateBlock.f_53341_, (Comparable)Boolean.valueOf(isOpen)), 10);
        Block block = blockstate.m_60734_();
        if (block instanceof FenceGateBlockAccessor) {
            FenceGateBlockAccessor fenceGateBlock = (FenceGateBlockAccessor)block;
            SoundEvent openSound = fenceGateBlock.tlmOpenSound();
            SoundEvent closeSound = fenceGateBlock.tlmCloseSound();
            serverLevel.m_245803_(entity, blockPos, isOpen ? openSound : closeSound, SoundSource.BLOCKS, 1.0f, serverLevel.m_213780_().m_188501_() * 0.1f + 0.9f);
        }
        serverLevel.m_142346_(entity, isOpen ? GameEvent.f_157796_ : GameEvent.f_157793_, blockPos);
    }
}

