/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;

public class MaidUpdateActivityFromSchedule
extends Behavior<EntityMaid> {
    private Activity cacheActivity;

    public MaidUpdateActivityFromSchedule() {
        super((Map)ImmutableMap.of());
    }

    protected void start(ServerLevel level, EntityMaid maid, long gameTime) {
        Brain<EntityMaid> brain = maid.m_6274_();
        long dayTime = level.m_46468_();
        if (gameTime - brain.f_21852_ > 20L) {
            Activity activity = brain.m_21932_().m_38019_((int)(dayTime % 24000L));
            if (this.cacheActivity == null) {
                this.cacheActivity = activity;
            }
            if (!this.cacheActivity.equals((Object)activity) && maid.isHomeModeEnable() && maid.canBrainMoving()) {
                this.cacheActivity = activity;
                maid.getSchedulePos().restrictTo(maid);
                BehaviorUtils.m_22617_((LivingEntity)maid, (BlockPos)maid.m_21534_(), (float)0.7f, (int)3);
            }
        }
        MaidUpdateActivityFromSchedule.updateActivityFromSchedule(level, maid, brain, gameTime);
    }

    public static void updateActivityFromSchedule(EntityMaid maid, Brain<EntityMaid> brain) {
        Level level = maid.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            long gameTime = serverLevel.m_46467_();
            MaidUpdateActivityFromSchedule.updateActivityFromSchedule(serverLevel, maid, brain, gameTime);
        }
    }

    public static void updateActivityFromSchedule(EntityMaid maid) {
        Level level = maid.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            long gameTime = serverLevel.m_46467_();
            Brain<EntityMaid> brain = maid.m_6274_();
            MaidUpdateActivityFromSchedule.updateActivityFromSchedule(serverLevel, maid, brain, gameTime);
        }
    }

    private static void updateActivityFromSchedule(ServerLevel level, EntityMaid maid, Brain<EntityMaid> brain, long gameTime) {
        long dayTime = level.m_46468_();
        if (maid.isMaidInSittingPose() || maid.m_20159_()) {
            if (gameTime - brain.f_21852_ > 20L) {
                brain.f_21852_ = gameTime;
                Activity activity = brain.m_21932_().m_38019_((int)(dayTime % 24000L));
                Activity riderActivity = activity.equals((Object)Activity.f_37980_) ? (Activity)InitEntities.RIDE_WORK.get() : (activity.equals((Object)Activity.f_37979_) ? (Activity)InitEntities.RIDE_IDLE.get() : (Activity)InitEntities.RIDE_REST.get());
                if (!brain.m_21954_(riderActivity)) {
                    brain.m_21936_(MemoryModuleType.f_26377_);
                    brain.m_21936_(MemoryModuleType.f_26370_);
                    brain.m_21889_(riderActivity);
                    if (maid.m_20159_() && !riderActivity.equals(InitEntities.RIDE_WORK.get())) {
                        if (!maid.getTask().workPointTask(maid)) {
                            return;
                        }
                        if (maid.m_20202_() instanceof EntitySit) {
                            return;
                        }
                        maid.m_8127_();
                    }
                }
            }
        } else {
            brain.m_21862_(dayTime, level.m_46467_());
        }
    }
}

