/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.projectile;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.DanmakuColor;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.DanmakuType;
import com.github.tartaricacid.touhoulittlemaid.init.InitDamage;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityDanmaku
extends ThrowableProjectile {
    public static final EntityType<EntityDanmaku> TYPE = EntityType.Builder.m_20704_(EntityDanmaku::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(6).m_20717_(10).m_20716_().m_20712_("danmaku");
    private static final int MAX_TICKS_EXISTED = 200;
    private static final EntityDataAccessor<Integer> DANMAKU_TYPE = SynchedEntityData.m_135353_(EntityDanmaku.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(EntityDanmaku.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(EntityDanmaku.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> GRAVITY = SynchedEntityData.m_135353_(EntityDanmaku.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int impedingLevel = 0;
    private boolean hurtEnderman = false;

    public EntityDanmaku(EntityType<? extends ThrowableProjectile> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityDanmaku(Level worldIn, LivingEntity throwerIn) {
        super(TYPE, throwerIn, worldIn);
    }

    public EntityDanmaku(Level worldIn, double x, double y, double z) {
        super(TYPE, x, y, z, worldIn);
    }

    private static boolean hasSameOwner(TamableAnimal tameableA, TamableAnimal tameableB) {
        if (tameableA.m_21805_() == null) {
            return false;
        }
        return tameableA.m_21805_().equals(tameableB.m_21805_());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DANMAKU_TYPE, (Object)DanmakuType.PELLET.ordinal());
        this.f_19804_.m_135372_(COLOR, (Object)DanmakuColor.RED.ordinal());
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(GRAVITY, (Object)Float.valueOf(0.01f));
    }

    protected void m_8060_(BlockHitResult result) {
        BlockPos pos = result.m_82425_();
        BlockState blockState = this.f_19853_.m_8055_(pos);
        if (!blockState.m_60812_((BlockGetter)this.f_19853_, pos).m_83281_()) {
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult result) {
        LivingEntity livingEntity;
        Entity thrower = this.m_19749_();
        Entity hit = result.m_82443_();
        if (thrower instanceof TamableAnimal) {
            TamableAnimal hitTameable;
            TamableAnimal tameable = (TamableAnimal)thrower;
            if (hit instanceof TamableAnimal && EntityDanmaku.hasSameOwner(tameable, hitTameable = (TamableAnimal)hit)) {
                this.m_146870_();
                return;
            }
            if (hit instanceof LivingEntity && tameable.m_7307_((Entity)(livingEntity = (LivingEntity)hit))) {
                this.m_146870_();
                return;
            }
            ResourceLocation registryName = ForgeRegistries.ENTITY_TYPES.getKey((Object)hit.m_6095_());
            if (registryName != null && ((List)MaidConfig.MAID_RANGED_ATTACK_IGNORE.get()).contains(registryName.toString())) {
                this.m_146870_();
                return;
            }
        }
        if (thrower != null && !hit.m_7306_(thrower)) {
            DamageSource source = InitDamage.danmakuDamage(thrower, this);
            hit.m_6469_(source, this.getDamage());
            if (this.impedingLevel > 0 && hit instanceof LivingEntity) {
                livingEntity = (LivingEntity)hit;
                int duration = (20 + this.impedingLevel * 10) * 20;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, duration, this.impedingLevel));
            }
            this.m_146870_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 200) {
            this.m_146870_();
        }
    }

    public boolean m_20069_() {
        return super.m_20069_();
    }

    protected float m_7139_() {
        return ((Float)this.f_19804_.m_135370_(GRAVITY)).floatValue();
    }

    public EntityDanmaku setGravityVelocity(float gravity) {
        this.f_19804_.m_135381_(GRAVITY, (Object)Float.valueOf(gravity));
        return this;
    }

    public DanmakuType getDanmakuType() {
        return DanmakuType.getType((Integer)this.f_19804_.m_135370_(DANMAKU_TYPE));
    }

    public EntityDanmaku setDanmakuType(DanmakuType type) {
        this.f_19804_.m_135381_(DANMAKU_TYPE, (Object)type.ordinal());
        return this;
    }

    public DanmakuColor getColor() {
        return DanmakuColor.getColor((Integer)this.f_19804_.m_135370_(COLOR));
    }

    public EntityDanmaku setColor(DanmakuColor color) {
        this.f_19804_.m_135381_(COLOR, (Object)color.ordinal());
        return this;
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public EntityDanmaku setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
        return this;
    }

    public EntityDanmaku setImpedingLevel(int impedingLevel) {
        this.impedingLevel = impedingLevel;
        return this;
    }

    public EntityDanmaku setHurtEnderman(boolean hurtEnderman) {
        this.hurtEnderman = hurtEnderman;
        return this;
    }

    public boolean isHurtEnderman() {
        return this.hurtEnderman;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

