/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidAttackStrafingTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRangedWalkToTarget;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidShootTargetTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.DanmakuShoot;
import com.github.tartaricacid.touhoulittlemaid.init.InitEnchantments;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.item.ItemHakureiGohei;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class TaskDanmakuAttack
implements IRangedAttackTask {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "danmaku_attack");

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return ((Item)InitItems.HAKUREI_GOHEI.get()).m_7968_();
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound(maid, (SoundEvent)InitSounds.MAID_DANMAKU_ATTACK.get(), 0.5f);
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.m_257741_(this::hasGohei, IRangedAttackTask::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.m_257990_(target -> !this.hasGohei(maid) || this.farAway((LivingEntity)target, maid));
        BehaviorControl<EntityMaid> moveToTargetTask = MaidRangedWalkToTarget.create(0.6f);
        MaidAttackStrafingTask maidAttackStrafingTask = new MaidAttackStrafingTask();
        MaidShootTargetTask shootTargetTask = new MaidShootTargetTask(2);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, moveToTargetTask), Pair.of((Object)5, (Object)((Object)maidAttackStrafingTask)), Pair.of((Object)5, (Object)((Object)shootTargetTask))});
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.m_257741_(this::hasGohei, IRangedAttackTask::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.m_257990_(target -> !this.hasGohei(maid) || this.farAway((LivingEntity)target, maid));
        MaidShootTargetTask shootTargetTask = new MaidShootTargetTask(2);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)((Object)shootTargetTask))});
    }

    @Override
    public boolean canSee(EntityMaid maid, LivingEntity target) {
        return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.DANMAKU_RANGE);
    }

    @Override
    public AABB searchDimension(EntityMaid maid) {
        if (this.hasGohei(maid)) {
            float searchRange = this.searchRadius(maid);
            if (maid.m_21536_()) {
                return new AABB(maid.m_21534_()).m_82400_((double)searchRange);
            }
            return maid.m_20191_().m_82400_((double)searchRange);
        }
        return IRangedAttackTask.super.searchDimension(maid);
    }

    @Override
    public float searchRadius(EntityMaid maid) {
        return ((Integer)MaidConfig.DANMAKU_RANGE.get()).intValue();
    }

    @Override
    public void performRangedAttack(EntityMaid shooter, LivingEntity target, float distanceFactor) {
        shooter.m_6274_().m_21952_(MemoryModuleType.f_148204_).ifPresent(livingEntities -> {
            ItemStack mainHandItem = shooter.m_21205_();
            if (ItemHakureiGohei.isGohei(mainHandItem)) {
                long entityCount = livingEntities.stream().filter(test -> this.enemyEntityTest(shooter, target, (LivingEntity)test)).count();
                Level level = shooter.m_9236_();
                AttributeInstance attackDamage = shooter.m_21051_(Attributes.f_22281_);
                float attackValue = 2.0f;
                if (attackDamage != null) {
                    attackValue = (float)attackDamage.m_22115_();
                }
                int impedingLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)InitEnchantments.IMPEDING.get()), (ItemStack)mainHandItem);
                int speedyLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)InitEnchantments.SPEEDY.get()), (ItemStack)mainHandItem);
                int multiShotLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44959_, (ItemStack)mainHandItem);
                int endersEnderLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)InitEnchantments.ENDERS_ENDER.get()), (ItemStack)mainHandItem);
                float speed = 0.3f * (distanceFactor + 1.0f) * (float)(speedyLevel + 1);
                boolean hurtEnderman = endersEnderLevel > 0;
                float distance = shooter.m_20270_((Entity)target);
                speed += Mth.m_14036_((float)(distance / 40.0f - 0.4f), (float)0.0f, (float)2.4f);
                float inaccuracy = 1.0f - Mth.m_14036_((float)(distance / 100.0f), (float)0.0f, (float)0.8f);
                if (entityCount <= 1L) {
                    if (multiShotLevel > 0) {
                        DanmakuShoot.create().setWorld(level).setThrower((LivingEntity)shooter).setTarget(target).setRandomColor().setRandomType().setDamage(attackValue * (distanceFactor + 1.2f)).setGravity(0.0f).setVelocity(speed).setHurtEnderman(hurtEnderman).setInaccuracy(inaccuracy).setFanNum(3).setYawTotal(0.2617993877991494).setImpedingLevel(impedingLevel).fanShapedShot();
                    } else {
                        DanmakuShoot.create().setWorld(level).setThrower((LivingEntity)shooter).setTarget(target).setRandomColor().setRandomType().setDamage(attackValue * (distanceFactor + 1.0f)).setGravity(0.0f).setVelocity(speed).setHurtEnderman(hurtEnderman).setInaccuracy(inaccuracy / 5.0f).setImpedingLevel(impedingLevel).aimedShot();
                    }
                } else if (entityCount <= 5L) {
                    DanmakuShoot.create().setWorld(level).setThrower((LivingEntity)shooter).setTarget(target).setRandomColor().setRandomType().setDamage(attackValue * (distanceFactor + 1.2f)).setGravity(0.0f).setVelocity(speed).setHurtEnderman(hurtEnderman).setInaccuracy(inaccuracy / 5.0f).setFanNum(8).setYawTotal(1.0471975511965976).setImpedingLevel(impedingLevel).fanShapedShot();
                } else {
                    DanmakuShoot.create().setWorld(level).setThrower((LivingEntity)shooter).setTarget(target).setRandomColor().setRandomType().setDamage(attackValue * (distanceFactor + 1.5f)).setGravity(0.0f).setVelocity(speed).setHurtEnderman(hurtEnderman).setInaccuracy(inaccuracy / 5.0f).setFanNum(32).setYawTotal(2.0943951023931953).setImpedingLevel(impedingLevel).fanShapedShot();
                }
                mainHandItem.m_41622_(1, (LivingEntity)shooter, maid -> maid.m_21190_(InteractionHand.MAIN_HAND));
            }
        });
    }

    private boolean enemyEntityTest(EntityMaid shooter, LivingEntity target, LivingEntity test) {
        boolean canAttack = shooter.m_6779_(test);
        boolean sameType = target.m_6095_().equals(test.m_6095_());
        return canAttack && sameType && shooter.canSee(test);
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Collections.singletonList(Pair.of((Object)"has_gohei", this::hasGohei));
    }

    private boolean hasGohei(EntityMaid maid) {
        return ItemHakureiGohei.isGohei(maid.m_21205_());
    }

    private boolean farAway(LivingEntity target, EntityMaid maid) {
        return maid.m_20270_((Entity)target) > this.searchRadius(maid);
    }
}

