/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFeedAnimalTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.task.DefaultMaidTaskConfigContainer;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.items.IItemHandler;

public class TaskFeedAnimal
implements IAttackTask {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "feed_animal");
    private static final int MAX_STOP_ATTACK_DISTANCE = 8;

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return Items.f_42405_.m_7968_();
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.environmentSound(maid, (SoundEvent)InitSounds.MAID_FEED_ANIMAL.get(), 0.5f);
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.m_257741_(this::hasAssaultWeapon, this::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.m_257990_(target -> !this.hasAssaultWeapon(maid) || this.farAway((LivingEntity)target, maid));
        BehaviorControl moveToTargetTask = SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)0.6f);
        OneShot attackTargetTask = MeleeAttack.m_257733_((int)20);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)((Object)new MaidFeedAnimalTask(0.6f, (int)((Integer)MaidConfig.FEED_ANIMAL_MAX_NUMBER.get())))), Pair.of((Object)6, (Object)supplementedTask), Pair.of((Object)6, (Object)findTargetTask), Pair.of((Object)6, (Object)moveToTargetTask), Pair.of((Object)6, (Object)attackTargetTask)});
    }

    @Override
    private Optional<? extends LivingEntity> findFirstValidAttackTarget(EntityMaid maid) {
        long animalCount = this.getEntities(maid).m_186128_(e -> maid.m_21444_(e.m_20183_())).filter(Entity::m_6084_).filter(e -> e instanceof Animal).count();
        if (animalCount < (long)((Integer)MaidConfig.FEED_ANIMAL_MAX_NUMBER.get() - 2)) {
            return Optional.empty();
        }
        return this.getEntities(maid).m_186128_(e -> maid.m_21444_(e.m_20183_())).filter(Entity::m_6084_).filter(e -> e instanceof Animal).filter(e -> ((Animal)e).m_146764_() == 0).filter(e -> ((Animal)e).m_5957_()).filter(e -> ItemsUtil.isStackIn((IItemHandler)maid.getAvailableInv(false), arg_0 -> ((Animal)((Animal)e)).m_6898_(arg_0))).filter(maid::canPathReach).findFirst();
    }

    @Override
    public boolean canAttack(EntityMaid maid, LivingEntity target) {
        return true;
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"can_feed", (Object)Predicates.alwaysTrue()), Pair.of((Object)"assault_weapon", this::hasAssaultWeapon)});
    }

    @Override
    public MenuProvider getTaskConfigGuiProvider(EntityMaid maid) {
        final int entityId = maid.m_19879_();
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Maid Task Config Container");
            }

            public AbstractMaidContainer createMenu(int index, Inventory playerInventory, Player player) {
                return new DefaultMaidTaskConfigContainer(index, playerInventory, entityId);
            }
        };
    }

    private NearestVisibleLivingEntities getEntities(EntityMaid maid) {
        return maid.m_6274_().m_21952_(MemoryModuleType.f_148205_).orElse(NearestVisibleLivingEntities.m_186106_());
    }

    private boolean hasAssaultWeapon(EntityMaid maid) {
        return maid.m_21205_().m_41638_(EquipmentSlot.MAINHAND).containsKey((Object)Attributes.f_22281_);
    }

    private boolean farAway(LivingEntity target, EntityMaid maid) {
        return maid.m_20270_((Entity)target) > 8.0f;
    }
}

