/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.util.json;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.Animation;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.ILoopType;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.BoneAnimation;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.bone.BoneKeyFrame;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.bone.BoneKeyFrameProcessor;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.event.EventKeyFrame;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.MolangParser;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.value.IValue;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.AnimationUtils;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.json.JsonKeyFrameUtils;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.ChainedJsonException;
import org.apache.commons.compress.utils.Lists;

public class JsonAnimationUtils {
    public static Set<Map.Entry<String, JsonElement>> getAnimations(JsonObject json) {
        if (json.has("animations")) {
            return json.getAsJsonObject("animations").entrySet();
        }
        return ImmutableSet.of();
    }

    public static List<Map.Entry<String, JsonElement>> getBones(JsonObject json) {
        JsonObject bones = json.getAsJsonObject("bones");
        return bones == null ? List.of() : new ArrayList(bones.entrySet());
    }

    public static List<Map.Entry<String, JsonElement>> getCustomInstructionKeyFrames(JsonObject json) {
        JsonObject customInstructions = json.getAsJsonObject("timeline");
        return customInstructions == null ? List.of() : new ArrayList(customInstructions.entrySet());
    }

    private static JsonElement getObjectByKey(Set<Map.Entry<String, JsonElement>> json, String key) throws ChainedJsonException {
        for (Map.Entry<String, JsonElement> entry : json) {
            if (!entry.getKey().equals(key)) continue;
            return entry.getValue();
        }
        throw new ChainedJsonException("Could not find key: " + key);
    }

    public static Map.Entry<String, JsonElement> getAnimation(JsonObject animationFile, String animationName) throws ChainedJsonException {
        return new AbstractMap.SimpleEntry<String, JsonElement>(animationName, JsonAnimationUtils.getObjectByKey(JsonAnimationUtils.getAnimations(animationFile), animationName));
    }

    public static Animation deserializeJsonToAnimation(Map.Entry<String, JsonElement> element, MolangParser parser) throws ClassCastException, IllegalStateException {
        JsonObject animationJsonObject = element.getValue().getAsJsonObject();
        String animationName = element.getKey();
        JsonElement animationLength = animationJsonObject.get("animation_length");
        double animationLengthTicks = animationLength == null ? -1.0 : AnimationUtils.convertSecondsToTicks(animationLength.getAsDouble());
        ILoopType loop = ILoopType.fromJson(animationJsonObject.get("loop"));
        ReferenceArrayList boneAnimations = new ReferenceArrayList();
        ReferenceArrayList customInstructionKeyframes = new ReferenceArrayList();
        for (Map.Entry<String, JsonElement> keyFrame : JsonAnimationUtils.getCustomInstructionKeyFrames(animationJsonObject)) {
            double startTick = Double.parseDouble(keyFrame.getKey()) * 20.0;
            JsonElement value = keyFrame.getValue();
            if (value.isJsonArray()) {
                JsonArray array = value.getAsJsonArray();
                IValue[] values = new IValue[array.size()];
                for (int i = 0; i < array.size(); ++i) {
                    String parserText = array.get(i).getAsString();
                    values[i] = parser.parseExpression(parserText);
                }
                customInstructionKeyframes.add(new EventKeyFrame<IValue[]>(startTick, values));
                continue;
            }
            if (!value.isJsonPrimitive() || !value.getAsJsonPrimitive().isString()) continue;
            IValue[] values = new IValue[]{parser.parseExpression(value.getAsString())};
            customInstructionKeyframes.add(new EventKeyFrame<IValue[]>(startTick, values));
        }
        customInstructionKeyframes.sort(Comparator.comparingDouble(EventKeyFrame::getStartTick));
        for (Map.Entry<String, JsonElement> bone : JsonAnimationUtils.getBones(animationJsonObject)) {
            ArrayList rotationKeyFrames = Lists.newArrayList();
            ArrayList positionKeyFrames = Lists.newArrayList();
            ArrayList scaleKeyFrames = Lists.newArrayList();
            JsonObject boneJsonObj = bone.getValue().getAsJsonObject();
            JsonKeyFrameUtils.getKeyFrames(scaleKeyFrames, boneJsonObj.get("scale"), parser);
            JsonKeyFrameUtils.getKeyFrames(positionKeyFrames, boneJsonObj.get("position"), parser);
            JsonKeyFrameUtils.getKeyFrames(rotationKeyFrames, boneJsonObj.get("rotation"), parser);
            boneAnimations.add((Object)new BoneAnimation(bone.getKey(), BoneKeyFrameProcessor.process(rotationKeyFrames, true), BoneKeyFrameProcessor.process(positionKeyFrames, false), BoneKeyFrameProcessor.process(scaleKeyFrames, false)));
        }
        if (animationLengthTicks == -1.0) {
            animationLengthTicks = JsonAnimationUtils.calculateLength((List<BoneAnimation>)boneAnimations);
        }
        return new Animation(animationName, animationLengthTicks, loop, (ReferenceArrayList<BoneAnimation>)boneAnimations, (ReferenceArrayList<EventKeyFrame<IValue[]>>)customInstructionKeyframes);
    }

    private static double calculateLength(List<BoneAnimation> boneAnimations) {
        double longestLength = 0.0;
        for (BoneAnimation animation : boneAnimations) {
            double xKeyframeTime = JsonAnimationUtils.calculateKeyFrameListLength(animation.rotationKeyFrames);
            double yKeyframeTime = JsonAnimationUtils.calculateKeyFrameListLength(animation.positionKeyFrames);
            double zKeyframeTime = JsonAnimationUtils.calculateKeyFrameListLength(animation.scaleKeyFrames);
            longestLength = JsonAnimationUtils.maxAll(longestLength, xKeyframeTime, yKeyframeTime, zKeyframeTime);
        }
        return longestLength == 0.0 ? Double.MAX_VALUE : longestLength;
    }

    private static double calculateKeyFrameListLength(List<BoneKeyFrame> boneKeyFrames) {
        if (boneKeyFrames.isEmpty()) {
            return 0.0;
        }
        return boneKeyFrames.get(boneKeyFrames.size() - 1).getStartTick();
    }

    public static double maxAll(double ... values) {
        double max = 0.0;
        for (double value : values) {
            max = Math.max(value, max);
        }
        return max;
    }
}

